/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1String;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBMPString;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.c;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public abstract class ASN1BMPString
extends ASN1Primitive
implements ASN1String {
    static final c a = new c(ASN1BMPString.class, 30){

        @Override
        ASN1Primitive a(DEROctetString dEROctetString) {
            return ASN1BMPString.a(dEROctetString.getOctets());
        }
    };
    final char[] b;

    public static ASN1BMPString getInstance(Object obj) {
        ASN1Primitive aSN1Primitive;
        if (obj == null || obj instanceof ASN1BMPString) {
            return (ASN1BMPString)obj;
        }
        if (obj instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1BMPString) {
            return (ASN1BMPString)aSN1Primitive;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1BMPString)a.a((byte[])obj);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1BMPString getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1BMPString)a.a(taggedObject, explicit);
    }

    ASN1BMPString(String string) {
        if (string == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        this.b = string.toCharArray();
    }

    ASN1BMPString(byte[] string) {
        if (string == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        int n2 = string.length;
        if (0 != (n2 & 1)) {
            throw new IllegalArgumentException("malformed BMPString encoding encountered");
        }
        int n3 = n2 / 2;
        char[] cArray = new char[n3];
        for (int i2 = 0; i2 != n3; ++i2) {
            cArray[i2] = (char)(string[2 * i2] << 8 | string[2 * i2 + 1] & 0xFF);
        }
        this.b = cArray;
    }

    ASN1BMPString(char[] string) {
        if (string == null) {
            throw new NullPointerException("'string' cannot be null");
        }
        this.b = string;
    }

    @Override
    public final String getString() {
        return new String(this.b);
    }

    public String toString() {
        return this.getString();
    }

    @Override
    final boolean a(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1BMPString)) {
            return false;
        }
        ASN1BMPString aSN1BMPString = (ASN1BMPString)aSN1Primitive;
        return Arrays.areEqual(this.b, aSN1BMPString.b);
    }

    @Override
    public final int hashCode() {
        return Arrays.hashCode(this.b);
    }

    @Override
    final boolean a() {
        return false;
    }

    @Override
    final int a(boolean bl) {
        return ASN1OutputStream.b(bl, this.b.length * 2);
    }

    @Override
    final void a(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        char c2;
        int n2;
        int n3;
        int n4 = this.b.length;
        aSN1OutputStream.a(bl, 30);
        aSN1OutputStream.a(n4 * 2);
        byte[] byArray = new byte[8];
        int n5 = n4 & 0xFFFFFFFC;
        for (n3 = 0; n3 < n5; n3 += 4) {
            n2 = this.b[n3];
            c2 = this.b[n3 + 1];
            char c3 = this.b[n3 + 2];
            char c4 = this.b[n3 + 3];
            byArray[0] = (byte)(n2 >> 8);
            byArray[1] = (byte)n2;
            byArray[2] = (byte)(c2 >> 8);
            byArray[3] = (byte)c2;
            byArray[4] = (byte)(c3 >> 8);
            byArray[5] = (byte)c3;
            byArray[6] = (byte)(c4 >> 8);
            byArray[7] = (byte)c4;
            aSN1OutputStream.a(byArray, 0, 8);
        }
        if (n3 < n4) {
            n2 = 0;
            do {
                c2 = this.b[n3];
                byArray[n2++] = (byte)(c2 >> 8);
                byArray[n2++] = (byte)c2;
            } while (++n3 < n4);
            aSN1OutputStream.a(byArray, 0, n2);
        }
    }

    static ASN1BMPString a(byte[] byArray) {
        return new DERBMPString(byArray);
    }

    static ASN1BMPString a(char[] cArray) {
        return new DERBMPString(cArray);
    }
}

