/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1BitStringParser;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1ParsingException;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1String;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DLBitString;
import com.enterprisedt.bouncycastle.asn1.c;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class ASN1BitString
extends ASN1Primitive
implements ASN1BitStringParser,
ASN1String {
    static final c a = new c(ASN1BitString.class, 3){

        @Override
        ASN1Primitive a(DEROctetString dEROctetString) {
            return ASN1BitString.a(dEROctetString.getOctets());
        }

        @Override
        ASN1Primitive a(ASN1Sequence aSN1Sequence) {
            return aSN1Sequence.e();
        }
    };
    private static final char[] c = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    final byte[] b;

    public static ASN1BitString getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1BitString) {
            return (ASN1BitString)obj;
        }
        if (obj instanceof ASN1Encodable) {
            ASN1Primitive aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive();
            if (aSN1Primitive instanceof ASN1BitString) {
                return (ASN1BitString)aSN1Primitive;
            }
        } else if (obj instanceof byte[]) {
            try {
                return (ASN1BitString)a.a((byte[])obj);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct BIT STRING from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1BitString getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1BitString)a.a(taggedObject, explicit);
    }

    protected static int getPadBits(int bitString) {
        int n2;
        int n3 = 0;
        for (n2 = 3; n2 >= 0; --n2) {
            if (n2 != 0) {
                if (bitString >> n2 * 8 == 0) continue;
                n3 = bitString >> n2 * 8 & 0xFF;
                break;
            }
            if (bitString == 0) continue;
            n3 = bitString & 0xFF;
            break;
        }
        if (n3 == 0) {
            return 0;
        }
        n2 = 1;
        while (((n3 <<= 1) & 0xFF) != 0) {
            ++n2;
        }
        return 8 - n2;
    }

    protected static byte[] getBytes(int bitString) {
        if (bitString == 0) {
            return new byte[0];
        }
        int n2 = 4;
        for (int i2 = 3; i2 >= 1 && (bitString & 255 << i2 * 8) == 0; --i2) {
            --n2;
        }
        byte[] byArray = new byte[n2];
        for (int i3 = 0; i3 < n2; ++i3) {
            byArray[i3] = (byte)(bitString >> i3 * 8 & 0xFF);
        }
        return byArray;
    }

    ASN1BitString(byte data, int padBits) {
        if (padBits > 7 || padBits < 0) {
            throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
        }
        this.b = new byte[]{(byte)padBits, data};
    }

    ASN1BitString(byte[] data, int padBits) {
        if (data == null) {
            throw new NullPointerException("'data' cannot be null");
        }
        if (data.length == 0 && padBits != 0) {
            throw new IllegalArgumentException("zero length data with non-zero pad bits");
        }
        if (padBits > 7 || padBits < 0) {
            throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
        }
        this.b = Arrays.prepend(data, (byte)padBits);
    }

    ASN1BitString(byte[] contents, boolean check) {
        if (check) {
            if (null == contents) {
                throw new NullPointerException("'contents' cannot be null");
            }
            if (contents.length < 1) {
                throw new IllegalArgumentException("'contents' cannot be empty");
            }
            int n2 = contents[0] & 0xFF;
            if (n2 > 0) {
                if (contents.length < 2) {
                    throw new IllegalArgumentException("zero length data with non-zero pad bits");
                }
                if (n2 > 7) {
                    throw new IllegalArgumentException("pad bits cannot be greater than 7 or less than 0");
                }
            }
        }
        this.b = contents;
    }

    @Override
    public InputStream getBitStream() throws IOException {
        return new ByteArrayInputStream(this.b, 1, this.b.length - 1);
    }

    @Override
    public InputStream getOctetStream() throws IOException {
        int n2 = this.b[0] & 0xFF;
        if (0 != n2) {
            throw new IOException("expected octet-aligned bitstring, but found padBits: " + n2);
        }
        return this.getBitStream();
    }

    public ASN1BitStringParser parser() {
        return this;
    }

    @Override
    public String getString() {
        byte[] byArray;
        try {
            byArray = this.getEncoded();
        }
        catch (IOException iOException) {
            throw new ASN1ParsingException("Internal error encoding BitString: " + iOException.getMessage(), iOException);
        }
        StringBuffer stringBuffer = new StringBuffer(1 + byArray.length * 2);
        stringBuffer.append('#');
        for (int i2 = 0; i2 != byArray.length; ++i2) {
            byte by = byArray[i2];
            stringBuffer.append(c[by >>> 4 & 0xF]);
            stringBuffer.append(c[by & 0xF]);
        }
        return stringBuffer.toString();
    }

    public int intValue() {
        int n2;
        int n3 = 0;
        int n4 = Math.min(5, this.b.length - 1);
        for (n2 = 1; n2 < n4; ++n2) {
            n3 |= (this.b[n2] & 0xFF) << 8 * (n2 - 1);
        }
        if (1 <= n4 && n4 < 5) {
            n2 = this.b[0] & 0xFF;
            byte by = (byte)(this.b[n4] & 255 << n2);
            n3 |= (by & 0xFF) << 8 * (n4 - 1);
        }
        return n3;
    }

    public byte[] getOctets() {
        if (this.b[0] != 0) {
            throw new IllegalStateException("attempt to get non-octet aligned data from BIT STRING");
        }
        return Arrays.copyOfRange(this.b, 1, this.b.length);
    }

    public byte[] getBytes() {
        if (this.b.length == 1) {
            return ASN1OctetString.b;
        }
        int n2 = this.b[0] & 0xFF;
        byte[] byArray = Arrays.copyOfRange(this.b, 1, this.b.length);
        int n3 = byArray.length - 1;
        byArray[n3] = (byte)(byArray[n3] & (byte)(255 << n2));
        return byArray;
    }

    @Override
    public int getPadBits() {
        return this.b[0] & 0xFF;
    }

    public String toString() {
        return this.getString();
    }

    @Override
    public int hashCode() {
        if (this.b.length < 2) {
            return 1;
        }
        int n2 = this.b[0] & 0xFF;
        int n3 = this.b.length - 1;
        byte by = (byte)(this.b[n3] & 255 << n2);
        int n4 = Arrays.hashCode(this.b, 0, n3);
        n4 *= 257;
        return n4 ^= by;
    }

    @Override
    boolean a(ASN1Primitive aSN1Primitive) {
        int n2;
        if (!(aSN1Primitive instanceof ASN1BitString)) {
            return false;
        }
        ASN1BitString aSN1BitString = (ASN1BitString)aSN1Primitive;
        byte[] byArray = aSN1BitString.b;
        byte[] byArray2 = this.b;
        int n3 = byArray2.length;
        if (byArray.length != n3) {
            return false;
        }
        if (n3 == 1) {
            return true;
        }
        int n4 = n3 - 1;
        for (n2 = 0; n2 < n4; ++n2) {
            if (byArray2[n2] == byArray[n2]) continue;
            return false;
        }
        n2 = byArray2[0] & 0xFF;
        byte by = (byte)(byArray2[n4] & 255 << n2);
        byte by2 = (byte)(byArray[n4] & 255 << n2);
        return by == by2;
    }

    @Override
    public ASN1Primitive getLoadedObject() {
        return this.toASN1Primitive();
    }

    @Override
    ASN1Primitive b() {
        return new DERBitString(this.b, false);
    }

    @Override
    ASN1Primitive c() {
        return new DLBitString(this.b, false);
    }

    static ASN1BitString a(byte[] byArray) {
        int n2 = byArray.length;
        if (n2 < 1) {
            throw new IllegalArgumentException("truncated BIT STRING detected");
        }
        int n3 = byArray[0] & 0xFF;
        if (n3 > 0) {
            if (n3 > 7 || n2 < 2) {
                throw new IllegalArgumentException("invalid pad bits detected");
            }
            byte by = byArray[n2 - 1];
            if (by != (byte)(by & 255 << n3)) {
                return new DLBitString(byArray, false);
            }
        }
        return new DERBitString(byArray, false);
    }
}

