/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.c;
import java.io.IOException;

public class ASN1Boolean
extends ASN1Primitive {
    static final c a = new c(ASN1Boolean.class, 1){

        @Override
        ASN1Primitive a(DEROctetString dEROctetString) {
            return ASN1Boolean.a(dEROctetString.getOctets());
        }
    };
    public static final ASN1Boolean FALSE = new ASN1Boolean(0);
    public static final ASN1Boolean TRUE = new ASN1Boolean(-1);
    private final byte b;

    public static ASN1Boolean getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Boolean) {
            return (ASN1Boolean)obj;
        }
        if (obj instanceof byte[]) {
            byte[] byArray = (byte[])obj;
            try {
                return (ASN1Boolean)a.a(byArray);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct boolean from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Boolean getInstance(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static ASN1Boolean getInstance(int value) {
        return value != 0 ? TRUE : FALSE;
    }

    public static ASN1Boolean getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1Boolean)a.a(taggedObject, explicit);
    }

    private ASN1Boolean(byte value) {
        this.b = value;
    }

    public boolean isTrue() {
        return this.b != 0;
    }

    @Override
    boolean a() {
        return false;
    }

    @Override
    int a(boolean bl) {
        return ASN1OutputStream.b(bl, 1);
    }

    @Override
    void a(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.a(bl, 1, this.b);
    }

    @Override
    boolean a(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Boolean)) {
            return false;
        }
        ASN1Boolean aSN1Boolean = (ASN1Boolean)aSN1Primitive;
        return this.isTrue() == aSN1Boolean.isTrue();
    }

    @Override
    public int hashCode() {
        return this.isTrue() ? 1 : 0;
    }

    @Override
    ASN1Primitive b() {
        return this.isTrue() ? TRUE : FALSE;
    }

    public String toString() {
        return this.isTrue() ? "TRUE" : "FALSE";
    }

    static ASN1Boolean a(byte[] byArray) {
        if (byArray.length != 1) {
            throw new IllegalArgumentException("BOOLEAN value should have 1 byte in it");
        }
        byte by = byArray[0];
        switch (by) {
            case 0: {
                return FALSE;
            }
            case -1: {
                return TRUE;
            }
        }
        return new ASN1Boolean(by);
    }
}

