/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.c;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;

public class ASN1Enumerated
extends ASN1Primitive {
    static final c a = new c(ASN1Enumerated.class, 10){

        @Override
        ASN1Primitive a(DEROctetString dEROctetString) {
            return ASN1Enumerated.a(dEROctetString.getOctets(), false);
        }
    };
    private final byte[] b;
    private final int c;
    private static final ASN1Enumerated[] d = new ASN1Enumerated[12];

    public static ASN1Enumerated getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Enumerated) {
            return (ASN1Enumerated)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1Enumerated)a.a((byte[])obj);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Enumerated getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1Enumerated)a.a(taggedObject, explicit);
    }

    public ASN1Enumerated(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("enumerated must be non-negative");
        }
        this.b = BigInteger.valueOf(value).toByteArray();
        this.c = 0;
    }

    public ASN1Enumerated(BigInteger value) {
        if (value.signum() < 0) {
            throw new IllegalArgumentException("enumerated must be non-negative");
        }
        this.b = value.toByteArray();
        this.c = 0;
    }

    public ASN1Enumerated(byte[] contents) {
        this(contents, true);
    }

    ASN1Enumerated(byte[] contents, boolean clone) {
        if (ASN1Integer.b(contents)) {
            throw new IllegalArgumentException("malformed enumerated");
        }
        if (0 != (contents[0] & 0x80)) {
            throw new IllegalArgumentException("enumerated must be non-negative");
        }
        this.b = clone ? Arrays.clone(contents) : contents;
        this.c = ASN1Integer.c(contents);
    }

    public BigInteger getValue() {
        return new BigInteger(this.b);
    }

    public boolean hasValue(int x) {
        return this.b.length - this.c <= 4 && ASN1Integer.a(this.b, this.c, -1) == x;
    }

    public boolean hasValue(BigInteger x) {
        return null != x && ASN1Integer.a(this.b, this.c, -1) == x.intValue() && this.getValue().equals(x);
    }

    public int intValueExact() {
        int n2 = this.b.length - this.c;
        if (n2 > 4) {
            throw new ArithmeticException("ASN.1 Enumerated out of int range");
        }
        return ASN1Integer.a(this.b, this.c, -1);
    }

    @Override
    boolean a() {
        return false;
    }

    @Override
    int a(boolean bl) {
        return ASN1OutputStream.b(bl, this.b.length);
    }

    @Override
    void a(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.a(bl, 10, this.b);
    }

    @Override
    boolean a(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Enumerated)) {
            return false;
        }
        ASN1Enumerated aSN1Enumerated = (ASN1Enumerated)aSN1Primitive;
        return Arrays.areEqual(this.b, aSN1Enumerated.b);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.b);
    }

    static ASN1Enumerated a(byte[] byArray, boolean bl) {
        if (byArray.length > 1) {
            return new ASN1Enumerated(byArray, bl);
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("ENUMERATED has zero length");
        }
        int n2 = byArray[0] & 0xFF;
        if (n2 >= d.length) {
            return new ASN1Enumerated(byArray, bl);
        }
        ASN1Enumerated aSN1Enumerated = d[n2];
        if (aSN1Enumerated == null) {
            aSN1Enumerated = ASN1Enumerated.d[n2] = new ASN1Enumerated(byArray, bl);
        }
        return aSN1Enumerated;
    }
}

