/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERGeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.LocaleUtil;
import com.enterprisedt.bouncycastle.asn1.c;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class ASN1GeneralizedTime
extends ASN1Primitive {
    static final c a = new c(ASN1GeneralizedTime.class, 24){

        @Override
        ASN1Primitive a(DEROctetString dEROctetString) {
            return ASN1GeneralizedTime.a(dEROctetString.getOctets());
        }
    };
    final byte[] b;

    public static ASN1GeneralizedTime getInstance(Object obj) {
        ASN1Primitive aSN1Primitive;
        if (obj == null || obj instanceof ASN1GeneralizedTime) {
            return (ASN1GeneralizedTime)obj;
        }
        if (obj instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1GeneralizedTime) {
            return (ASN1GeneralizedTime)aSN1Primitive;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1GeneralizedTime)a.a((byte[])obj);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1GeneralizedTime getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1GeneralizedTime)a.a(taggedObject, explicit);
    }

    public ASN1GeneralizedTime(String time) {
        this.b = Strings.toByteArray(time);
        try {
            this.getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("invalid date string: " + parseException.getMessage());
        }
    }

    public ASN1GeneralizedTime(Date time) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'", LocaleUtil.EN_Locale);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.b = Strings.toByteArray(simpleDateFormat.format(time));
    }

    public ASN1GeneralizedTime(Date time, Locale locale) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'", locale);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.b = Strings.toByteArray(simpleDateFormat.format(time));
    }

    ASN1GeneralizedTime(byte[] bytes) {
        if (bytes.length < 4) {
            throw new IllegalArgumentException("GeneralizedTime string too short");
        }
        this.b = bytes;
        if (!(this.b(0) && this.b(1) && this.b(2) && this.b(3))) {
            throw new IllegalArgumentException("illegal characters in GeneralizedTime string");
        }
    }

    public String getTimeString() {
        return Strings.fromByteArray(this.b);
    }

    public String getTime() {
        String string = Strings.fromByteArray(this.b);
        if (string.charAt(string.length() - 1) == 'Z') {
            return string.substring(0, string.length() - 1) + "GMT+00:00";
        }
        int n2 = string.length() - 6;
        char c2 = string.charAt(n2);
        if ((c2 == '-' || c2 == '+') && string.indexOf("GMT") == n2 - 3) {
            return string;
        }
        n2 = string.length() - 5;
        c2 = string.charAt(n2);
        if (c2 == '-' || c2 == '+') {
            return string.substring(0, n2) + "GMT" + string.substring(n2, n2 + 3) + ":" + string.substring(n2 + 3);
        }
        n2 = string.length() - 3;
        c2 = string.charAt(n2);
        if (c2 == '-' || c2 == '+') {
            return string.substring(0, n2) + "GMT" + string.substring(n2) + ":00";
        }
        return string + this.a(string);
    }

    private String a(String string) {
        String string2 = "+";
        TimeZone timeZone = TimeZone.getDefault();
        int n2 = timeZone.getRawOffset();
        if (n2 < 0) {
            string2 = "-";
            n2 = -n2;
        }
        int n3 = n2 / 3600000;
        int n4 = (n2 - n3 * 60 * 60 * 1000) / 60000;
        try {
            if (timeZone.useDaylightTime()) {
                SimpleDateFormat simpleDateFormat;
                if (this.hasFractionalSeconds()) {
                    string = this.b(string);
                }
                if (timeZone.inDaylightTime((simpleDateFormat = this.d()).parse(string + "GMT" + string2 + this.a(n3) + ":" + this.a(n4)))) {
                    n3 += string2.equals("+") ? 1 : -1;
                }
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return "GMT" + string2 + this.a(n3) + ":" + this.a(n4);
    }

    private SimpleDateFormat d() {
        SimpleDateFormat simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSSz") : (this.hasSeconds() ? new SimpleDateFormat("yyyyMMddHHmmssz") : (this.hasMinutes() ? new SimpleDateFormat("yyyyMMddHHmmz") : new SimpleDateFormat("yyyyMMddHHz")));
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        return simpleDateFormat;
    }

    private String b(String string) {
        char c2;
        int n2;
        String string2 = string.substring(14);
        for (n2 = 1; n2 < string2.length() && '0' <= (c2 = string2.charAt(n2)) && c2 <= '9'; ++n2) {
        }
        if (n2 - 1 > 3) {
            string2 = string2.substring(0, 4) + string2.substring(n2);
            string = string.substring(0, 14) + string2;
        } else if (n2 - 1 == 1) {
            string2 = string2.substring(0, n2) + "00" + string2.substring(n2);
            string = string.substring(0, 14) + string2;
        } else if (n2 - 1 == 2) {
            string2 = string2.substring(0, n2) + "0" + string2.substring(n2);
            string = string.substring(0, 14) + string2;
        }
        return string;
    }

    private String a(int n2) {
        if (n2 < 10) {
            return "0" + n2;
        }
        return Integer.toString(n2);
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat simpleDateFormat;
        String string;
        String string2 = string = Strings.fromByteArray(this.b);
        if (string.endsWith("Z")) {
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'", LocaleUtil.EN_Locale) : (this.hasSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss'Z'", LocaleUtil.EN_Locale) : (this.hasMinutes() ? new SimpleDateFormat("yyyyMMddHHmm'Z'", LocaleUtil.EN_Locale) : new SimpleDateFormat("yyyyMMddHH'Z'", LocaleUtil.EN_Locale)));
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        } else if (string.indexOf(45) > 0 || string.indexOf(43) > 0) {
            string2 = this.getTime();
            simpleDateFormat = this.d();
        } else {
            simpleDateFormat = this.hasFractionalSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss.SSS") : (this.hasSeconds() ? new SimpleDateFormat("yyyyMMddHHmmss") : (this.hasMinutes() ? new SimpleDateFormat("yyyyMMddHHmm") : new SimpleDateFormat("yyyyMMddHH")));
            simpleDateFormat.setTimeZone(new SimpleTimeZone(0, TimeZone.getDefault().getID()));
        }
        if (this.hasFractionalSeconds()) {
            string2 = this.b(string2);
        }
        return simpleDateFormat.parse(string2);
    }

    protected boolean hasFractionalSeconds() {
        for (int i2 = 0; i2 != this.b.length; ++i2) {
            if (this.b[i2] != 46 || i2 != 14) continue;
            return true;
        }
        return false;
    }

    protected boolean hasSeconds() {
        return this.b(12) && this.b(13);
    }

    protected boolean hasMinutes() {
        return this.b(10) && this.b(11);
    }

    private boolean b(int n2) {
        return this.b.length > n2 && this.b[n2] >= 48 && this.b[n2] <= 57;
    }

    @Override
    final boolean a() {
        return false;
    }

    @Override
    int a(boolean bl) {
        return ASN1OutputStream.b(bl, this.b.length);
    }

    @Override
    void a(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.a(bl, 24, this.b);
    }

    @Override
    ASN1Primitive b() {
        return new DERGeneralizedTime(this.b);
    }

    @Override
    boolean a(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1GeneralizedTime)) {
            return false;
        }
        return Arrays.areEqual(this.b, ((ASN1GeneralizedTime)aSN1Primitive).b);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.b);
    }

    static ASN1GeneralizedTime a(byte[] byArray) {
        return new ASN1GeneralizedTime(byArray);
    }
}

