/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1BMPString;
import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1Boolean;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Enumerated;
import com.enterprisedt.bouncycastle.asn1.ASN1Exception;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralString;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1GraphicString;
import com.enterprisedt.bouncycastle.asn1.ASN1IA5String;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Null;
import com.enterprisedt.bouncycastle.asn1.ASN1NumericString;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectDescriptor;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1PrintableString;
import com.enterprisedt.bouncycastle.asn1.ASN1RelativeOID;
import com.enterprisedt.bouncycastle.asn1.ASN1StreamParser;
import com.enterprisedt.bouncycastle.asn1.ASN1T61String;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.ASN1UTCTime;
import com.enterprisedt.bouncycastle.asn1.ASN1UTF8String;
import com.enterprisedt.bouncycastle.asn1.ASN1UniversalString;
import com.enterprisedt.bouncycastle.asn1.ASN1VideotexString;
import com.enterprisedt.bouncycastle.asn1.ASN1VisibleString;
import com.enterprisedt.bouncycastle.asn1.BERBitString;
import com.enterprisedt.bouncycastle.asn1.BERBitStringParser;
import com.enterprisedt.bouncycastle.asn1.BEROctetString;
import com.enterprisedt.bouncycastle.asn1.BEROctetStringParser;
import com.enterprisedt.bouncycastle.asn1.BERSequenceParser;
import com.enterprisedt.bouncycastle.asn1.BERSetParser;
import com.enterprisedt.bouncycastle.asn1.BERTags;
import com.enterprisedt.bouncycastle.asn1.DERExternalParser;
import com.enterprisedt.bouncycastle.asn1.k;
import com.enterprisedt.bouncycastle.asn1.n;
import com.enterprisedt.bouncycastle.asn1.o;
import com.enterprisedt.bouncycastle.asn1.q;
import com.enterprisedt.bouncycastle.asn1.s;
import com.enterprisedt.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ASN1InputStream
extends FilterInputStream
implements BERTags {
    private final int a;
    private final boolean b;
    private final byte[][] c;

    public ASN1InputStream(InputStream is) {
        this(is, s.a(is));
    }

    public ASN1InputStream(byte[] input) {
        this((InputStream)new ByteArrayInputStream(input), input.length);
    }

    public ASN1InputStream(byte[] input, boolean lazyEvaluate) {
        this(new ByteArrayInputStream(input), input.length, lazyEvaluate);
    }

    public ASN1InputStream(InputStream input, int limit) {
        this(input, limit, false);
    }

    public ASN1InputStream(InputStream input, boolean lazyEvaluate) {
        this(input, s.a(input), lazyEvaluate);
    }

    public ASN1InputStream(InputStream input, int limit, boolean lazyEvaluate) {
        this(input, limit, lazyEvaluate, new byte[11][]);
    }

    private ASN1InputStream(InputStream input, int limit, boolean lazyEvaluate, byte[][] tmpBuffers) {
        super(input);
        this.a = limit;
        this.b = lazyEvaluate;
        this.c = tmpBuffers;
    }

    int a() {
        return this.a;
    }

    protected int readLength() throws IOException {
        return ASN1InputStream.a(this, this.a, false);
    }

    protected void readFully(byte[] bytes) throws IOException {
        if (Streams.readFully(this, bytes, 0, bytes.length) != bytes.length) {
            throw new EOFException("EOF encountered in middle of object");
        }
    }

    protected ASN1Primitive buildObject(int tag, int tagNo, int length) throws IOException {
        n n2 = new n(this, length, this.a);
        if (0 == (tag & 0xE0)) {
            return ASN1InputStream.a(tagNo, n2, this.c);
        }
        int n3 = tag & 0xC0;
        if (0 != n3) {
            boolean bl = (tag & 0x20) != 0;
            return this.a(n3, tagNo, bl, n2);
        }
        switch (tagNo) {
            case 3: {
                return this.a(this.a(n2));
            }
            case 4: {
                return this.b(this.a(n2));
            }
            case 16: {
                if (n2.a() < 1) {
                    return k.a;
                }
                if (this.b) {
                    return new q(n2.b());
                }
                return k.a(this.a(n2));
            }
            case 17: {
                return k.b(this.a(n2));
            }
            case 8: {
                return k.a(this.a(n2)).f();
            }
        }
        throw new IOException("unknown tag " + tagNo + " encountered");
    }

    public ASN1Primitive readObject() throws IOException {
        int n2 = this.read();
        if (n2 <= 0) {
            if (n2 == 0) {
                throw new IOException("unexpected end-of-contents marker");
            }
            return null;
        }
        int n3 = ASN1InputStream.a(this, n2);
        int n4 = this.readLength();
        if (n4 >= 0) {
            try {
                return this.buildObject(n2, n3, n4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ASN1Exception("corrupted stream detected", illegalArgumentException);
            }
        }
        if (0 == (n2 & 0x20)) {
            throw new IOException("indefinite-length primitive encoding encountered");
        }
        o o2 = new o(this, this.a);
        ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(o2, this.a, this.c);
        int n5 = n2 & 0xC0;
        if (0 != n5) {
            return aSN1StreamParser.a(n5, n3);
        }
        switch (n3) {
            case 3: {
                return BERBitStringParser.a(aSN1StreamParser);
            }
            case 4: {
                return BEROctetStringParser.a(aSN1StreamParser);
            }
            case 8: {
                return DERExternalParser.a(aSN1StreamParser);
            }
            case 16: {
                return BERSequenceParser.a(aSN1StreamParser);
            }
            case 17: {
                return BERSetParser.a(aSN1StreamParser);
            }
        }
        throw new IOException("unknown BER object encountered");
    }

    ASN1BitString a(ASN1EncodableVector aSN1EncodableVector) throws IOException {
        ASN1BitString[] aSN1BitStringArray = new ASN1BitString[aSN1EncodableVector.size()];
        for (int i2 = 0; i2 != aSN1BitStringArray.length; ++i2) {
            ASN1Encodable aSN1Encodable = aSN1EncodableVector.get(i2);
            if (!(aSN1Encodable instanceof ASN1BitString)) {
                throw new ASN1Exception("unknown object encountered in constructed BIT STRING: " + aSN1Encodable.getClass());
            }
            aSN1BitStringArray[i2] = (ASN1BitString)aSN1Encodable;
        }
        return new BERBitString(aSN1BitStringArray);
    }

    ASN1OctetString b(ASN1EncodableVector aSN1EncodableVector) throws IOException {
        ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[aSN1EncodableVector.size()];
        for (int i2 = 0; i2 != aSN1OctetStringArray.length; ++i2) {
            ASN1Encodable aSN1Encodable = aSN1EncodableVector.get(i2);
            if (!(aSN1Encodable instanceof ASN1OctetString)) {
                throw new ASN1Exception("unknown object encountered in constructed OCTET STRING: " + aSN1Encodable.getClass());
            }
            aSN1OctetStringArray[i2] = (ASN1OctetString)aSN1Encodable;
        }
        return new BEROctetString(aSN1OctetStringArray);
    }

    ASN1Primitive a(int n2, int n3, boolean bl, n n4) throws IOException {
        if (!bl) {
            byte[] byArray = n4.b();
            return ASN1TaggedObject.a(n2, n3, byArray);
        }
        ASN1EncodableVector aSN1EncodableVector = this.a(n4);
        return ASN1TaggedObject.a(n2, n3, aSN1EncodableVector);
    }

    ASN1EncodableVector b() throws IOException {
        ASN1Primitive aSN1Primitive = this.readObject();
        if (null == aSN1Primitive) {
            return new ASN1EncodableVector(0);
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        do {
            aSN1EncodableVector.add(aSN1Primitive);
        } while ((aSN1Primitive = this.readObject()) != null);
        return aSN1EncodableVector;
    }

    ASN1EncodableVector a(n n2) throws IOException {
        int n3 = n2.a();
        if (n3 < 1) {
            return new ASN1EncodableVector(0);
        }
        return new ASN1InputStream(n2, n3, this.b, this.c).b();
    }

    static int a(InputStream inputStream, int n2) throws IOException {
        int n3 = n2 & 0x1F;
        if (n3 == 31) {
            int n4 = inputStream.read();
            if (n4 < 31) {
                if (n4 < 0) {
                    throw new EOFException("EOF found inside tag value.");
                }
                throw new IOException("corrupted stream - high tag number < 31 found");
            }
            n3 = n4 & 0x7F;
            if (0 == n3) {
                throw new IOException("corrupted stream - invalid high tag number found");
            }
            while ((n4 & 0x80) != 0) {
                if (n3 >>> 24 != 0) {
                    throw new IOException("Tag number more than 31 bits");
                }
                n3 <<= 7;
                n4 = inputStream.read();
                if (n4 < 0) {
                    throw new EOFException("EOF found inside tag value.");
                }
                n3 |= n4 & 0x7F;
            }
        }
        return n3;
    }

    static int a(InputStream inputStream, int n2, boolean bl) throws IOException {
        int n3 = inputStream.read();
        if (0 == n3 >>> 7) {
            return n3;
        }
        if (128 == n3) {
            return -1;
        }
        if (n3 < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (255 == n3) {
            throw new IOException("invalid long form definite-length 0xFF");
        }
        int n4 = n3 & 0x7F;
        int n5 = 0;
        n3 = 0;
        do {
            int n6;
            if ((n6 = inputStream.read()) < 0) {
                throw new EOFException("EOF found reading length");
            }
            if (n3 >>> 23 != 0) {
                throw new IOException("long form definite-length more than 31 bits");
            }
            n3 = (n3 << 8) + n6;
        } while (++n5 < n4);
        if (n3 >= n2 && !bl) {
            throw new IOException("corrupted stream - out of bounds length found: " + n3 + " >= " + n2);
        }
        return n3;
    }

    private static byte[] a(n n2, byte[][] byArray) throws IOException {
        int n3 = n2.a();
        if (n3 >= byArray.length) {
            return n2.b();
        }
        byte[] byArray2 = byArray[n3];
        if (byArray2 == null) {
            byArray[n3] = new byte[n3];
            byArray2 = byArray[n3];
        }
        n2.a(byArray2);
        return byArray2;
    }

    private static char[] b(n n2) throws IOException {
        int n3 = n2.a();
        if (0 != (n3 & 1)) {
            throw new IOException("malformed BMPString encoding encountered");
        }
        char[] cArray = new char[n3 / 2];
        int n4 = 0;
        byte[] byArray = new byte[8];
        while (n3 >= 8) {
            if (Streams.readFully(n2, byArray, 0, 8) != 8) {
                throw new EOFException("EOF encountered in middle of BMPString");
            }
            cArray[n4] = (char)(byArray[0] << 8 | byArray[1] & 0xFF);
            cArray[n4 + 1] = (char)(byArray[2] << 8 | byArray[3] & 0xFF);
            cArray[n4 + 2] = (char)(byArray[4] << 8 | byArray[5] & 0xFF);
            cArray[n4 + 3] = (char)(byArray[6] << 8 | byArray[7] & 0xFF);
            n4 += 4;
            n3 -= 8;
        }
        if (n3 > 0) {
            if (Streams.readFully(n2, byArray, 0, n3) != n3) {
                throw new EOFException("EOF encountered in middle of BMPString");
            }
            int n5 = 0;
            do {
                int n6 = byArray[n5++] << 8;
                int n7 = byArray[n5++] & 0xFF;
                cArray[n4++] = (char)(n6 | n7);
            } while (n5 < n3);
        }
        if (0 != n2.a() || cArray.length != n4) {
            throw new IllegalStateException();
        }
        return cArray;
    }

    static ASN1Primitive a(int n2, n n3, byte[][] byArray) throws IOException {
        try {
            switch (n2) {
                case 3: {
                    return ASN1BitString.a(n3.b());
                }
                case 30: {
                    return ASN1BMPString.a(ASN1InputStream.b(n3));
                }
                case 1: {
                    return ASN1Boolean.a(ASN1InputStream.a(n3, byArray));
                }
                case 10: {
                    return ASN1Enumerated.a(ASN1InputStream.a(n3, byArray), true);
                }
                case 27: {
                    return ASN1GeneralString.a(n3.b());
                }
                case 24: {
                    return ASN1GeneralizedTime.a(n3.b());
                }
                case 25: {
                    return ASN1GraphicString.a(n3.b());
                }
                case 22: {
                    return ASN1IA5String.a(n3.b());
                }
                case 2: {
                    return ASN1Integer.a(n3.b());
                }
                case 5: {
                    return ASN1Null.a(n3.b());
                }
                case 18: {
                    return ASN1NumericString.a(n3.b());
                }
                case 7: {
                    return ASN1ObjectDescriptor.a(n3.b());
                }
                case 6: {
                    return ASN1ObjectIdentifier.a(ASN1InputStream.a(n3, byArray), true);
                }
                case 4: {
                    return ASN1OctetString.a(n3.b());
                }
                case 19: {
                    return ASN1PrintableString.a(n3.b());
                }
                case 13: {
                    return ASN1RelativeOID.a(n3.b(), false);
                }
                case 20: {
                    return ASN1T61String.a(n3.b());
                }
                case 28: {
                    return ASN1UniversalString.a(n3.b());
                }
                case 23: {
                    return ASN1UTCTime.a(n3.b());
                }
                case 12: {
                    return ASN1UTF8String.a(n3.b());
                }
                case 21: {
                    return ASN1VideotexString.a(n3.b());
                }
                case 26: {
                    return ASN1VisibleString.a(n3.b());
                }
                case 14: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: {
                    throw new IOException("unsupported tag " + n2 + " encountered");
                }
            }
            throw new IOException("unknown tag " + n2 + " encountered");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ASN1Exception(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (IllegalStateException illegalStateException) {
            throw new ASN1Exception(illegalStateException.getMessage(), illegalStateException);
        }
    }
}

