/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.c;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Properties;
import java.io.IOException;
import java.math.BigInteger;

public class ASN1Integer
extends ASN1Primitive {
    static final c a = new c(ASN1Integer.class, 2){

        @Override
        ASN1Primitive a(DEROctetString dEROctetString) {
            return ASN1Integer.a(dEROctetString.getOctets());
        }
    };
    private final byte[] b;
    private final int c;

    public static ASN1Integer getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Integer) {
            return (ASN1Integer)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1Integer)a.a((byte[])obj);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Integer getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1Integer)a.a(taggedObject, explicit);
    }

    public ASN1Integer(long value) {
        this.b = BigInteger.valueOf(value).toByteArray();
        this.c = 0;
    }

    public ASN1Integer(BigInteger value) {
        this.b = value.toByteArray();
        this.c = 0;
    }

    public ASN1Integer(byte[] bytes) {
        this(bytes, true);
    }

    ASN1Integer(byte[] bytes, boolean clone) {
        if (ASN1Integer.b(bytes)) {
            throw new IllegalArgumentException("malformed integer");
        }
        this.b = clone ? Arrays.clone(bytes) : bytes;
        this.c = ASN1Integer.c(bytes);
    }

    public BigInteger getPositiveValue() {
        return new BigInteger(1, this.b);
    }

    public BigInteger getValue() {
        return new BigInteger(this.b);
    }

    public boolean hasValue(int x) {
        return this.b.length - this.c <= 4 && ASN1Integer.a(this.b, this.c, -1) == x;
    }

    public boolean hasValue(long x) {
        return this.b.length - this.c <= 8 && ASN1Integer.b(this.b, this.c, -1) == x;
    }

    public boolean hasValue(BigInteger x) {
        return null != x && ASN1Integer.a(this.b, this.c, -1) == x.intValue() && this.getValue().equals(x);
    }

    public int intPositiveValueExact() {
        int n2 = this.b.length - this.c;
        if (n2 > 4 || n2 == 4 && 0 != (this.b[this.c] & 0x80)) {
            throw new ArithmeticException("ASN.1 Integer out of positive int range");
        }
        return ASN1Integer.a(this.b, this.c, 255);
    }

    public int intValueExact() {
        int n2 = this.b.length - this.c;
        if (n2 > 4) {
            throw new ArithmeticException("ASN.1 Integer out of int range");
        }
        return ASN1Integer.a(this.b, this.c, -1);
    }

    public long longValueExact() {
        int n2 = this.b.length - this.c;
        if (n2 > 8) {
            throw new ArithmeticException("ASN.1 Integer out of long range");
        }
        return ASN1Integer.b(this.b, this.c, -1);
    }

    @Override
    boolean a() {
        return false;
    }

    @Override
    int a(boolean bl) {
        return ASN1OutputStream.b(bl, this.b.length);
    }

    @Override
    void a(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.a(bl, 2, this.b);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.b);
    }

    @Override
    boolean a(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Integer)) {
            return false;
        }
        ASN1Integer aSN1Integer = (ASN1Integer)aSN1Primitive;
        return Arrays.areEqual(this.b, aSN1Integer.b);
    }

    public String toString() {
        return this.getValue().toString();
    }

    static ASN1Integer a(byte[] byArray) {
        return new ASN1Integer(byArray, false);
    }

    static int a(byte[] byArray, int n2, int n3) {
        int n4 = byArray.length;
        int n5 = Math.max(n2, n4 - 4);
        int n6 = byArray[n5] & n3;
        while (++n5 < n4) {
            n6 = n6 << 8 | byArray[n5] & 0xFF;
        }
        return n6;
    }

    static long b(byte[] byArray, int n2, int n3) {
        int n4 = byArray.length;
        int n5 = Math.max(n2, n4 - 8);
        long l2 = byArray[n5] & n3;
        while (++n5 < n4) {
            l2 = l2 << 8 | (long)(byArray[n5] & 0xFF);
        }
        return l2;
    }

    static boolean b(byte[] byArray) {
        switch (byArray.length) {
            case 0: {
                return true;
            }
            case 1: {
                return false;
            }
        }
        return byArray[0] == byArray[1] >> 7 && !Properties.isOverrideSet("com.enterprisedt.bouncycastle.asn1.allow_unsafe_integer");
    }

    static int c(byte[] byArray) {
        int n2;
        int n3 = byArray.length - 1;
        for (n2 = 0; n2 < n3 && byArray[n2] == byArray[n2 + 1] >> 7; ++n2) {
        }
        return n2;
    }
}

