/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1String;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERNumericString;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.c;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;
import java.io.IOException;

public abstract class ASN1NumericString
extends ASN1Primitive
implements ASN1String {
    static final c a = new c(ASN1NumericString.class, 18){

        @Override
        ASN1Primitive a(DEROctetString dEROctetString) {
            return ASN1NumericString.a(dEROctetString.getOctets());
        }
    };
    final byte[] b;

    public static ASN1NumericString getInstance(Object obj) {
        ASN1Primitive aSN1Primitive;
        if (obj == null || obj instanceof ASN1NumericString) {
            return (ASN1NumericString)obj;
        }
        if (obj instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1NumericString) {
            return (ASN1NumericString)aSN1Primitive;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1NumericString)a.a((byte[])obj);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1NumericString getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1NumericString)a.a(taggedObject, explicit);
    }

    ASN1NumericString(String string, boolean validate) {
        if (validate && !ASN1NumericString.isNumericString(string)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.b = Strings.toByteArray(string);
    }

    ASN1NumericString(byte[] contents, boolean clone) {
        this.b = clone ? Arrays.clone(contents) : contents;
    }

    @Override
    public final String getString() {
        return Strings.fromByteArray(this.b);
    }

    public String toString() {
        return this.getString();
    }

    public final byte[] getOctets() {
        return Arrays.clone(this.b);
    }

    @Override
    final boolean a() {
        return false;
    }

    @Override
    final int a(boolean bl) {
        return ASN1OutputStream.b(bl, this.b.length);
    }

    @Override
    final void a(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.a(bl, 18, this.b);
    }

    @Override
    public final int hashCode() {
        return Arrays.hashCode(this.b);
    }

    @Override
    final boolean a(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1NumericString)) {
            return false;
        }
        ASN1NumericString aSN1NumericString = (ASN1NumericString)aSN1Primitive;
        return Arrays.areEqual(this.b, aSN1NumericString.b);
    }

    public static boolean isNumericString(String str) {
        for (int i2 = str.length() - 1; i2 >= 0; --i2) {
            char c2 = str.charAt(i2);
            if (c2 > '\u007f') {
                return false;
            }
            if ('0' <= c2 && c2 <= '9' || c2 == ' ') continue;
            return false;
        }
        return true;
    }

    static ASN1NumericString a(byte[] byArray) {
        return new DERNumericString(byArray, false);
    }
}

