/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.util.Encodable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class ASN1Object
implements ASN1Encodable,
Encodable {
    public void encodeTo(OutputStream output) throws IOException {
        this.toASN1Primitive().encodeTo(output);
    }

    public void encodeTo(OutputStream output, String encoding) throws IOException {
        this.toASN1Primitive().encodeTo(output, encoding);
    }

    @Override
    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.toASN1Primitive().encodeTo(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getEncoded(String encoding) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.toASN1Primitive().encodeTo(byteArrayOutputStream, encoding);
        return byteArrayOutputStream.toByteArray();
    }

    public int hashCode() {
        return this.toASN1Primitive().hashCode();
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof ASN1Encodable)) {
            return false;
        }
        ASN1Encodable aSN1Encodable = (ASN1Encodable)o2;
        return this.toASN1Primitive().equals(aSN1Encodable.toASN1Primitive());
    }

    protected static boolean hasEncodedTagValue(Object obj, int tagValue) {
        return obj instanceof byte[] && ((byte[])obj)[0] == tagValue;
    }

    @Override
    public abstract ASN1Primitive toASN1Primitive();
}

