/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1RelativeOID;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.OIDTokenizer;
import com.enterprisedt.bouncycastle.asn1.c;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ASN1ObjectIdentifier
extends ASN1Primitive {
    static final c a = new c(ASN1ObjectIdentifier.class, 6){

        @Override
        ASN1Primitive a(DEROctetString dEROctetString) {
            return ASN1ObjectIdentifier.a(dEROctetString.getOctets(), false);
        }
    };
    private static final ConcurrentMap<a, ASN1ObjectIdentifier> b = new ConcurrentHashMap<a, ASN1ObjectIdentifier>();
    private final String c;
    private byte[] d;

    public static ASN1ObjectIdentifier fromContents(byte[] contents) {
        return ASN1ObjectIdentifier.a(contents, true);
    }

    public static ASN1ObjectIdentifier getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1ObjectIdentifier) {
            return (ASN1ObjectIdentifier)obj;
        }
        if (obj instanceof ASN1Encodable) {
            ASN1Primitive aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive();
            if (aSN1Primitive instanceof ASN1ObjectIdentifier) {
                return (ASN1ObjectIdentifier)aSN1Primitive;
            }
        } else if (obj instanceof byte[]) {
            try {
                return (ASN1ObjectIdentifier)a.a((byte[])obj);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct object identifier from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1ObjectIdentifier getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        ASN1Primitive aSN1Primitive;
        if (!(explicit || taggedObject.d() || 128 != taggedObject.getTagClass() || (aSN1Primitive = taggedObject.getBaseObject().toASN1Primitive()) instanceof ASN1ObjectIdentifier)) {
            return ASN1ObjectIdentifier.fromContents(ASN1OctetString.getInstance(aSN1Primitive).getOctets());
        }
        return (ASN1ObjectIdentifier)a.a(taggedObject, explicit);
    }

    ASN1ObjectIdentifier(byte[] contents, boolean clone) {
        if (contents.length == 0) {
            throw new IllegalArgumentException("empty OBJECT IDENTIFIER with no sub-identifiers");
        }
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = 0L;
        BigInteger bigInteger = null;
        boolean bl = true;
        for (int i2 = 0; i2 != contents.length; ++i2) {
            int n2 = contents[i2] & 0xFF;
            if (l2 <= 0xFFFFFFFFFFFF80L) {
                l2 += (long)(n2 & 0x7F);
                if ((n2 & 0x80) == 0) {
                    if (bl) {
                        if (l2 < 40L) {
                            stringBuilder.append('0');
                        } else if (l2 < 80L) {
                            stringBuilder.append('1');
                            l2 -= 40L;
                        } else {
                            stringBuilder.append('2');
                            l2 -= 80L;
                        }
                        bl = false;
                    }
                    stringBuilder.append('.');
                    stringBuilder.append(l2);
                    l2 = 0L;
                    continue;
                }
                l2 <<= 7;
                continue;
            }
            if (bigInteger == null) {
                bigInteger = BigInteger.valueOf(l2);
            }
            bigInteger = bigInteger.or(BigInteger.valueOf(n2 & 0x7F));
            if ((n2 & 0x80) == 0) {
                if (bl) {
                    stringBuilder.append('2');
                    bigInteger = bigInteger.subtract(BigInteger.valueOf(80L));
                    bl = false;
                }
                stringBuilder.append('.');
                stringBuilder.append(bigInteger);
                bigInteger = null;
                l2 = 0L;
                continue;
            }
            bigInteger = bigInteger.shiftLeft(7);
        }
        this.c = stringBuilder.toString();
        this.d = clone ? Arrays.clone(contents) : contents;
    }

    public ASN1ObjectIdentifier(String identifier) {
        if (identifier == null) {
            throw new NullPointerException("'identifier' cannot be null");
        }
        if (!ASN1ObjectIdentifier.a(identifier)) {
            throw new IllegalArgumentException("string " + identifier + " not an OID");
        }
        this.c = identifier;
    }

    ASN1ObjectIdentifier(ASN1ObjectIdentifier oid, String branchID) {
        if (!ASN1RelativeOID.a(branchID, 0)) {
            throw new IllegalArgumentException("string " + branchID + " not a valid OID branch");
        }
        this.c = oid.getId() + "." + branchID;
    }

    public String getId() {
        return this.c;
    }

    public ASN1ObjectIdentifier branch(String branchID) {
        return new ASN1ObjectIdentifier(this, branchID);
    }

    public boolean on(ASN1ObjectIdentifier stem) {
        String string = this.getId();
        String string2 = stem.getId();
        return string.length() > string2.length() && string.charAt(string2.length()) == '.' && string.startsWith(string2);
    }

    private void a(ByteArrayOutputStream byteArrayOutputStream) {
        OIDTokenizer oIDTokenizer = new OIDTokenizer(this.c);
        int n2 = Integer.parseInt(oIDTokenizer.nextToken()) * 40;
        String string = oIDTokenizer.nextToken();
        if (string.length() <= 18) {
            ASN1RelativeOID.a(byteArrayOutputStream, (long)n2 + Long.parseLong(string));
        } else {
            ASN1RelativeOID.a(byteArrayOutputStream, new BigInteger(string).add(BigInteger.valueOf(n2)));
        }
        while (oIDTokenizer.hasMoreTokens()) {
            String string2 = oIDTokenizer.nextToken();
            if (string2.length() <= 18) {
                ASN1RelativeOID.a(byteArrayOutputStream, Long.parseLong(string2));
                continue;
            }
            ASN1RelativeOID.a(byteArrayOutputStream, new BigInteger(string2));
        }
    }

    private synchronized byte[] d() {
        if (this.d == null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.a(byteArrayOutputStream);
            this.d = byteArrayOutputStream.toByteArray();
        }
        return this.d;
    }

    @Override
    boolean a() {
        return false;
    }

    @Override
    int a(boolean bl) {
        return ASN1OutputStream.b(bl, this.d().length);
    }

    @Override
    void a(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.a(bl, 6, this.d());
    }

    @Override
    public int hashCode() {
        return this.c.hashCode();
    }

    @Override
    boolean a(ASN1Primitive aSN1Primitive) {
        if (aSN1Primitive == this) {
            return true;
        }
        if (!(aSN1Primitive instanceof ASN1ObjectIdentifier)) {
            return false;
        }
        return this.c.equals(((ASN1ObjectIdentifier)aSN1Primitive).c);
    }

    public String toString() {
        return this.getId();
    }

    private static boolean a(String string) {
        if (string.length() < 3 || string.charAt(1) != '.') {
            return false;
        }
        char c2 = string.charAt(0);
        if (c2 < '0' || c2 > '2') {
            return false;
        }
        return ASN1RelativeOID.a(string, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ASN1ObjectIdentifier intern() {
        a a2 = new a(this.d());
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)b.get(a2);
        if (aSN1ObjectIdentifier == null) {
            ConcurrentMap<a, ASN1ObjectIdentifier> concurrentMap = b;
            synchronized (concurrentMap) {
                if (!b.containsKey(a2)) {
                    b.put(a2, this);
                    return this;
                }
                return (ASN1ObjectIdentifier)b.get(a2);
            }
        }
        return aSN1ObjectIdentifier;
    }

    static ASN1ObjectIdentifier a(byte[] byArray, boolean bl) {
        a a2 = new a(byArray);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = (ASN1ObjectIdentifier)b.get(a2);
        if (aSN1ObjectIdentifier == null) {
            return new ASN1ObjectIdentifier(byArray, bl);
        }
        return aSN1ObjectIdentifier;
    }

    private static class a {
        private final int a;
        private final byte[] b;

        a(byte[] byArray) {
            this.a = Arrays.hashCode(byArray);
            this.b = byArray;
        }

        public int hashCode() {
            return this.a;
        }

        public boolean equals(Object o2) {
            if (o2 instanceof a) {
                return Arrays.areEqual(this.b, ((a)o2).b);
            }
            return false;
        }
    }
}

