/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1String;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERPrintableString;
import com.enterprisedt.bouncycastle.asn1.c;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;
import java.io.IOException;

public abstract class ASN1PrintableString
extends ASN1Primitive
implements ASN1String {
    static final c a = new c(ASN1PrintableString.class, 19){

        @Override
        ASN1Primitive a(DEROctetString dEROctetString) {
            return ASN1PrintableString.a(dEROctetString.getOctets());
        }
    };
    final byte[] b;

    public static ASN1PrintableString getInstance(Object obj) {
        ASN1Primitive aSN1Primitive;
        if (obj == null || obj instanceof ASN1PrintableString) {
            return (ASN1PrintableString)obj;
        }
        if (obj instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1PrintableString) {
            return (ASN1PrintableString)aSN1Primitive;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1PrintableString)a.a((byte[])obj);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1PrintableString getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1PrintableString)a.a(taggedObject, explicit);
    }

    ASN1PrintableString(String string, boolean validate) {
        if (validate && !ASN1PrintableString.isPrintableString(string)) {
            throw new IllegalArgumentException("string contains illegal characters");
        }
        this.b = Strings.toByteArray(string);
    }

    ASN1PrintableString(byte[] contents, boolean clone) {
        this.b = clone ? Arrays.clone(contents) : contents;
    }

    @Override
    public final String getString() {
        return Strings.fromByteArray(this.b);
    }

    public final byte[] getOctets() {
        return Arrays.clone(this.b);
    }

    @Override
    final boolean a() {
        return false;
    }

    @Override
    final int a(boolean bl) {
        return ASN1OutputStream.b(bl, this.b.length);
    }

    @Override
    final void a(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.a(bl, 19, this.b);
    }

    @Override
    final boolean a(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1PrintableString)) {
            return false;
        }
        ASN1PrintableString aSN1PrintableString = (ASN1PrintableString)aSN1Primitive;
        return Arrays.areEqual(this.b, aSN1PrintableString.b);
    }

    @Override
    public final int hashCode() {
        return Arrays.hashCode(this.b);
    }

    public String toString() {
        return this.getString();
    }

    public static boolean isPrintableString(String str) {
        block3: for (int i2 = str.length() - 1; i2 >= 0; --i2) {
            char c2 = str.charAt(i2);
            if (c2 > '\u007f') {
                return false;
            }
            if ('a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z' || '0' <= c2 && c2 <= '9') continue;
            switch (c2) {
                case ' ': 
                case '\'': 
                case '(': 
                case ')': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '=': 
                case '?': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    static ASN1PrintableString a(byte[] byArray) {
        return new DERPrintableString(byArray, false);
    }
}

