/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1External;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1SequenceParser;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DLSequence;
import com.enterprisedt.bouncycastle.asn1.c;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Iterable;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class ASN1Sequence
extends ASN1Primitive
implements Iterable<ASN1Encodable> {
    static final c a = new c(ASN1Sequence.class, 16){

        @Override
        ASN1Primitive a(ASN1Sequence aSN1Sequence) {
            return aSN1Sequence;
        }
    };
    ASN1Encodable[] b;

    public static ASN1Sequence getInstance(Object obj) {
        if (obj == null || obj instanceof ASN1Sequence) {
            return (ASN1Sequence)obj;
        }
        if (obj instanceof ASN1Encodable) {
            ASN1Primitive aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive();
            if (aSN1Primitive instanceof ASN1Sequence) {
                return (ASN1Sequence)aSN1Primitive;
            }
        } else if (obj instanceof byte[]) {
            try {
                return (ASN1Sequence)a.a((byte[])obj);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct sequence from byte[]: " + iOException.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1Sequence getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1Sequence)a.a(taggedObject, explicit);
    }

    protected ASN1Sequence() {
        this.b = ASN1EncodableVector.a;
    }

    protected ASN1Sequence(ASN1Encodable element) {
        if (null == element) {
            throw new NullPointerException("'element' cannot be null");
        }
        this.b = new ASN1Encodable[]{element};
    }

    protected ASN1Sequence(ASN1EncodableVector elementVector) {
        if (null == elementVector) {
            throw new NullPointerException("'elementVector' cannot be null");
        }
        this.b = elementVector.b();
    }

    protected ASN1Sequence(ASN1Encodable[] elements) {
        if (Arrays.isNullOrContainsNull(elements)) {
            throw new NullPointerException("'elements' cannot be null, or contain null");
        }
        this.b = ASN1EncodableVector.a(elements);
    }

    ASN1Sequence(ASN1Encodable[] elements, boolean clone) {
        this.b = clone ? ASN1EncodableVector.a(elements) : elements;
    }

    public ASN1Encodable[] toArray() {
        return ASN1EncodableVector.a(this.b);
    }

    ASN1Encodable[] d() {
        return this.b;
    }

    public Enumeration getObjects() {
        return new Enumeration(){
            private int b = 0;

            @Override
            public boolean hasMoreElements() {
                return this.b < ASN1Sequence.this.b.length;
            }

            public Object nextElement() {
                if (this.b < ASN1Sequence.this.b.length) {
                    return ASN1Sequence.this.b[this.b++];
                }
                throw new NoSuchElementException();
            }
        };
    }

    public ASN1SequenceParser parser() {
        final int n2 = this.size();
        return new ASN1SequenceParser(){
            private int c = 0;

            @Override
            public ASN1Encodable readObject() throws IOException {
                ASN1Encodable aSN1Encodable;
                if (n2 == this.c) {
                    return null;
                }
                if ((aSN1Encodable = ASN1Sequence.this.b[this.c++]) instanceof ASN1Sequence) {
                    return ((ASN1Sequence)aSN1Encodable).parser();
                }
                if (aSN1Encodable instanceof ASN1Set) {
                    return ((ASN1Set)aSN1Encodable).parser();
                }
                return aSN1Encodable;
            }

            @Override
            public ASN1Primitive getLoadedObject() {
                return ASN1Sequence.this;
            }

            @Override
            public ASN1Primitive toASN1Primitive() {
                return ASN1Sequence.this;
            }
        };
    }

    public ASN1Encodable getObjectAt(int index) {
        return this.b[index];
    }

    public int size() {
        return this.b.length;
    }

    @Override
    public int hashCode() {
        int n2 = this.b.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= this.b[n2].toASN1Primitive().hashCode();
        }
        return n3;
    }

    @Override
    boolean a(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1Primitive;
        int n2 = this.size();
        if (aSN1Sequence.size() != n2) {
            return false;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            ASN1Primitive aSN1Primitive2;
            ASN1Primitive aSN1Primitive3 = this.b[i2].toASN1Primitive();
            if (aSN1Primitive3 == (aSN1Primitive2 = aSN1Sequence.b[i2].toASN1Primitive()) || aSN1Primitive3.a(aSN1Primitive2)) continue;
            return false;
        }
        return true;
    }

    @Override
    ASN1Primitive b() {
        return new DERSequence(this.b, false);
    }

    @Override
    ASN1Primitive c() {
        return new DLSequence(this.b, false);
    }

    abstract ASN1BitString e();

    abstract ASN1External f();

    abstract ASN1OctetString g();

    abstract ASN1Set h();

    @Override
    boolean a() {
        return true;
    }

    public String toString() {
        int n2 = this.size();
        if (0 == n2) {
            return "[]";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('[');
        int n3 = 0;
        while (true) {
            stringBuffer.append(this.b[n3]);
            if (++n3 >= n2) break;
            stringBuffer.append(", ");
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    @Override
    public Iterator<ASN1Encodable> iterator() {
        return new Arrays.Iterator<ASN1Encodable>(this.b);
    }

    ASN1BitString[] i() {
        int n2 = this.size();
        ASN1BitString[] aSN1BitStringArray = new ASN1BitString[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            aSN1BitStringArray[i2] = ASN1BitString.getInstance(this.b[i2]);
        }
        return aSN1BitStringArray;
    }

    ASN1OctetString[] j() {
        int n2 = this.size();
        ASN1OctetString[] aSN1OctetStringArray = new ASN1OctetString[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            aSN1OctetStringArray[i2] = ASN1OctetString.getInstance(this.b[i2]);
        }
        return aSN1OctetStringArray;
    }
}

