/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1OutputStream;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.LocaleUtil;
import com.enterprisedt.bouncycastle.asn1.c;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;

public class ASN1UTCTime
extends ASN1Primitive {
    static final c a = new c(ASN1UTCTime.class, 23){

        @Override
        ASN1Primitive a(DEROctetString dEROctetString) {
            return ASN1UTCTime.a(dEROctetString.getOctets());
        }
    };
    final byte[] b;

    public static ASN1UTCTime getInstance(Object obj) {
        ASN1Primitive aSN1Primitive;
        if (obj == null || obj instanceof ASN1UTCTime) {
            return (ASN1UTCTime)obj;
        }
        if (obj instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1UTCTime) {
            return (ASN1UTCTime)aSN1Primitive;
        }
        if (obj instanceof byte[]) {
            try {
                return (ASN1UTCTime)a.a((byte[])obj);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("encoding error in getInstance: " + exception.toString());
            }
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static ASN1UTCTime getInstance(ASN1TaggedObject taggedObject, boolean explicit) {
        return (ASN1UTCTime)a.a(taggedObject, explicit);
    }

    public ASN1UTCTime(String time) {
        this.b = Strings.toByteArray(time);
        try {
            this.getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalArgumentException("invalid date string: " + parseException.getMessage());
        }
    }

    public ASN1UTCTime(Date time) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'", LocaleUtil.EN_Locale);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.b = Strings.toByteArray(simpleDateFormat.format(time));
    }

    public ASN1UTCTime(Date time, Locale locale) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmss'Z'", locale);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        this.b = Strings.toByteArray(simpleDateFormat.format(time));
    }

    ASN1UTCTime(byte[] contents) {
        if (contents.length < 2) {
            throw new IllegalArgumentException("UTCTime string too short");
        }
        this.b = contents;
        if (!this.a(0) || !this.a(1)) {
            throw new IllegalArgumentException("illegal characters in UTCTime string");
        }
    }

    public Date getDate() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMddHHmmssz", LocaleUtil.EN_Locale);
        return simpleDateFormat.parse(this.getTime());
    }

    public Date getAdjustedDate() throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssz", LocaleUtil.EN_Locale);
        simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
        return simpleDateFormat.parse(this.getAdjustedTime());
    }

    public String getTime() {
        String string = Strings.fromByteArray(this.b);
        if (string.indexOf(45) < 0 && string.indexOf(43) < 0) {
            if (string.length() == 11) {
                return string.substring(0, 10) + "00GMT+00:00";
            }
            return string.substring(0, 12) + "GMT+00:00";
        }
        int n2 = string.indexOf(45);
        if (n2 < 0) {
            n2 = string.indexOf(43);
        }
        String string2 = string;
        if (n2 == string.length() - 3) {
            string2 = string2 + "00";
        }
        if (n2 == 10) {
            return string2.substring(0, 10) + "00GMT" + string2.substring(10, 13) + ":" + string2.substring(13, 15);
        }
        return string2.substring(0, 12) + "GMT" + string2.substring(12, 15) + ":" + string2.substring(15, 17);
    }

    public String getAdjustedTime() {
        String string = this.getTime();
        if (string.charAt(0) < '5') {
            return "20" + string;
        }
        return "19" + string;
    }

    private boolean a(int n2) {
        return this.b.length > n2 && this.b[n2] >= 48 && this.b[n2] <= 57;
    }

    @Override
    final boolean a() {
        return false;
    }

    @Override
    int a(boolean bl) {
        return ASN1OutputStream.b(bl, this.b.length);
    }

    @Override
    void a(ASN1OutputStream aSN1OutputStream, boolean bl) throws IOException {
        aSN1OutputStream.a(bl, 23, this.b);
    }

    @Override
    boolean a(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof ASN1UTCTime)) {
            return false;
        }
        return Arrays.areEqual(this.b, ((ASN1UTCTime)aSN1Primitive).b);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.b);
    }

    public String toString() {
        return Strings.fromByteArray(this.b);
    }

    static ASN1UTCTime a(byte[] byArray) {
        return new ASN1UTCTime(byArray);
    }
}

