/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.bc;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralNames;
import com.enterprisedt.bouncycastle.util.Arrays;

public class ExternalValue
extends ASN1Object {
    private final GeneralNames a;
    private final AlgorithmIdentifier b;
    private final byte[] c;

    public ExternalValue(GeneralName location, AlgorithmIdentifier hashAlg, byte[] hashVal) {
        this.a = new GeneralNames(location);
        this.b = hashAlg;
        this.c = Arrays.clone(hashVal);
    }

    private ExternalValue(ASN1Sequence seq) {
        if (seq.size() == 3) {
            this.a = GeneralNames.getInstance(seq.getObjectAt(0));
            this.b = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
            this.c = seq.getObjectAt(2) instanceof ASN1BitString ? ASN1BitString.getInstance(seq.getObjectAt(2)).getOctets() : ASN1OctetString.getInstance(seq.getObjectAt(2)).getOctets();
        } else {
            throw new IllegalArgumentException("unknown sequence");
        }
    }

    public static ExternalValue getInstance(Object o2) {
        if (o2 instanceof ExternalValue) {
            return (ExternalValue)o2;
        }
        if (o2 != null) {
            return new ExternalValue(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public GeneralName getLocation() {
        return this.a.getNames()[0];
    }

    public GeneralName[] getLocations() {
        return this.a.getNames();
    }

    public AlgorithmIdentifier getHashAlg() {
        return this.b;
    }

    public byte[] getHashValue() {
        return Arrays.clone(this.c);
    }

    public ASN1BitString getHashVal() {
        return new DERBitString(this.c);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(new DEROctetString(this.c));
        return new DERSequence(aSN1EncodableVector);
    }
}

