/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.bc;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x509.DigestInfo;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralName;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralNames;

public class LinkedCertificate
extends ASN1Object {
    private final DigestInfo a;
    private final GeneralName b;
    private X500Name c;
    private GeneralNames d;

    public LinkedCertificate(DigestInfo digest, GeneralName certLocation) {
        this(digest, certLocation, null, null);
    }

    public LinkedCertificate(DigestInfo digest, GeneralName certLocation, X500Name certIssuer, GeneralNames cACerts) {
        this.a = digest;
        this.b = certLocation;
        this.c = certIssuer;
        this.d = cACerts;
    }

    private LinkedCertificate(ASN1Sequence seq) {
        this.a = DigestInfo.getInstance(seq.getObjectAt(0));
        this.b = GeneralName.getInstance(seq.getObjectAt(1));
        if (seq.size() > 2) {
            block4: for (int i2 = 2; i2 != seq.size(); ++i2) {
                ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(seq.getObjectAt(i2));
                switch (aSN1TaggedObject.getTagNo()) {
                    case 0: {
                        this.c = X500Name.getInstance(aSN1TaggedObject, false);
                        continue block4;
                    }
                    case 1: {
                        this.d = GeneralNames.getInstance(aSN1TaggedObject, false);
                        continue block4;
                    }
                    default: {
                        throw new IllegalArgumentException("unknown tag in tagged field");
                    }
                }
            }
        }
    }

    public static LinkedCertificate getInstance(Object o2) {
        if (o2 instanceof LinkedCertificate) {
            return (LinkedCertificate)o2;
        }
        if (o2 != null) {
            return new LinkedCertificate(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public DigestInfo getDigest() {
        return this.a;
    }

    public GeneralName getCertLocation() {
        return this.b;
    }

    public X500Name getCertIssuer() {
        return this.c;
    }

    public GeneralNames getCACerts() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(4);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, (ASN1Encodable)this.c));
        }
        if (this.d != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, (ASN1Encodable)this.d));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

