/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.bc;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.bc.PbkdMacIntegrityCheck;
import com.enterprisedt.bouncycastle.asn1.bc.SignatureCheck;
import java.io.IOException;

public class ObjectStoreIntegrityCheck
extends ASN1Object
implements ASN1Choice {
    public static final int PBKD_MAC_CHECK = 0;
    public static final int SIG_CHECK = 1;
    private final int a;
    private final ASN1Object b;

    public ObjectStoreIntegrityCheck(PbkdMacIntegrityCheck macIntegrityCheck) {
        this((ASN1Encodable)macIntegrityCheck);
    }

    public ObjectStoreIntegrityCheck(SignatureCheck signatureCheck) {
        this(new DERTaggedObject(0, signatureCheck));
    }

    private ObjectStoreIntegrityCheck(ASN1Encodable obj) {
        if (obj instanceof ASN1Sequence || obj instanceof PbkdMacIntegrityCheck) {
            this.a = 0;
            this.b = PbkdMacIntegrityCheck.getInstance(obj);
        } else if (obj instanceof ASN1TaggedObject) {
            this.a = 1;
            this.b = SignatureCheck.getInstance(((ASN1TaggedObject)obj).getExplicitBaseObject());
        } else {
            throw new IllegalArgumentException("Unknown check object in integrity check.");
        }
    }

    public static ObjectStoreIntegrityCheck getInstance(Object o2) {
        if (o2 instanceof ObjectStoreIntegrityCheck) {
            return (ObjectStoreIntegrityCheck)o2;
        }
        if (o2 instanceof byte[]) {
            try {
                return new ObjectStoreIntegrityCheck(ASN1Primitive.fromByteArray((byte[])o2));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Unable to parse integrity check details.");
            }
        }
        if (o2 != null) {
            return new ObjectStoreIntegrityCheck((ASN1Encodable)o2);
        }
        return null;
    }

    public int getType() {
        return this.a;
    }

    public ASN1Object getIntegrityCheck() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.b instanceof SignatureCheck) {
            return new DERTaggedObject(0, this.b);
        }
        return this.b.toASN1Primitive();
    }
}

