/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.bc;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.Certificate;
import com.enterprisedt.bouncycastle.util.Arrays;

public class SignatureCheck
extends ASN1Object {
    private final AlgorithmIdentifier a;
    private final ASN1Sequence b;
    private final ASN1BitString c;

    public SignatureCheck(AlgorithmIdentifier signatureAlgorithm, byte[] signature) {
        this.a = signatureAlgorithm;
        this.b = null;
        this.c = new DERBitString(Arrays.clone(signature));
    }

    public SignatureCheck(AlgorithmIdentifier signatureAlgorithm, Certificate[] certificates, byte[] signature) {
        this.a = signatureAlgorithm;
        this.b = new DERSequence(certificates);
        this.c = new DERBitString(Arrays.clone(signature));
    }

    private SignatureCheck(ASN1Sequence seq) {
        this.a = AlgorithmIdentifier.getInstance(seq.getObjectAt(0));
        int n2 = 1;
        this.b = seq.getObjectAt(1) instanceof ASN1TaggedObject ? ASN1Sequence.getInstance(ASN1TaggedObject.getInstance(seq.getObjectAt(n2++)).getBaseUniversal(true, 16)) : null;
        this.c = ASN1BitString.getInstance(seq.getObjectAt(n2));
    }

    public static SignatureCheck getInstance(Object o2) {
        if (o2 instanceof SignatureCheck) {
            return (SignatureCheck)o2;
        }
        if (o2 != null) {
            return new SignatureCheck(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public ASN1BitString getSignature() {
        return new DERBitString(this.c.getBytes(), this.c.getPadBits());
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.a;
    }

    public Certificate[] getCertificates() {
        if (this.b == null) {
            return null;
        }
        Certificate[] certificateArray = new Certificate[this.b.size()];
        for (int i2 = 0; i2 != certificateArray.length; ++i2) {
            certificateArray[i2] = Certificate.getInstance(this.b.getObjectAt(i2));
        }
        return certificateArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(0, this.b));
        }
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }
}

