/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.cryptopro;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import java.math.BigInteger;
import java.util.Enumeration;

public class GOST3410ParamSetParameters
extends ASN1Object {
    int a;
    ASN1Integer b;
    ASN1Integer c;
    ASN1Integer d;

    public static GOST3410ParamSetParameters getInstance(ASN1TaggedObject obj, boolean explicit) {
        return GOST3410ParamSetParameters.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static GOST3410ParamSetParameters getInstance(Object obj) {
        if (obj == null || obj instanceof GOST3410ParamSetParameters) {
            return (GOST3410ParamSetParameters)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new GOST3410ParamSetParameters((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("Invalid GOST3410Parameter: " + obj.getClass().getName());
    }

    public GOST3410ParamSetParameters(int keySize, BigInteger p2, BigInteger q2, BigInteger a2) {
        this.a = keySize;
        this.b = new ASN1Integer(p2);
        this.c = new ASN1Integer(q2);
        this.d = new ASN1Integer(a2);
    }

    public GOST3410ParamSetParameters(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        this.a = ((ASN1Integer)enumeration.nextElement()).intValueExact();
        this.b = (ASN1Integer)enumeration.nextElement();
        this.c = (ASN1Integer)enumeration.nextElement();
        this.d = (ASN1Integer)enumeration.nextElement();
    }

    public int getLKeySize() {
        return this.a;
    }

    public int getKeySize() {
        return this.a;
    }

    public BigInteger getP() {
        return this.b.getPositiveValue();
    }

    public BigInteger getQ() {
        return this.c.getPositiveValue();
    }

    public BigInteger getA() {
        return this.d.getPositiveValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(4);
        aSN1EncodableVector.add(new ASN1Integer(this.a));
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        return new DERSequence(aSN1EncodableVector);
    }
}

