/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.eac;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.eac.CertificateHolderAuthorization;
import com.enterprisedt.bouncycastle.asn1.eac.CertificateHolderReference;
import com.enterprisedt.bouncycastle.asn1.eac.CertificationAuthorityReference;
import com.enterprisedt.bouncycastle.asn1.eac.PackedDate;
import com.enterprisedt.bouncycastle.asn1.eac.PublicKeyDataObject;
import com.enterprisedt.bouncycastle.asn1.eac.a;
import java.io.IOException;

public class CertificateBody
extends ASN1Object {
    private ASN1TaggedObject a;
    private ASN1TaggedObject b;
    private PublicKeyDataObject c;
    private ASN1TaggedObject d;
    private CertificateHolderAuthorization e;
    private ASN1TaggedObject f;
    private ASN1TaggedObject g;
    private int h = 0;
    public static final int profileType = 127;
    public static final int requestType = 13;

    private void a(ASN1TaggedObject aSN1TaggedObject) throws IOException {
        if (!aSN1TaggedObject.hasTag(64, 78)) {
            throw new IOException("Bad tag : not an iso7816 CERTIFICATE_CONTENT_TEMPLATE");
        }
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1TaggedObject.getBaseUniversal(false, 16));
        int n2 = aSN1Sequence.size();
        block9: for (int i2 = 0; i2 < n2; ++i2) {
            ASN1TaggedObject aSN1TaggedObject2 = ASN1TaggedObject.getInstance(aSN1Sequence.getObjectAt(i2), 64);
            switch (aSN1TaggedObject2.getTagNo()) {
                case 41: {
                    this.b(aSN1TaggedObject2);
                    continue block9;
                }
                case 2: {
                    this.d(aSN1TaggedObject2);
                    continue block9;
                }
                case 73: {
                    this.a(PublicKeyDataObject.getInstance(aSN1TaggedObject2.getBaseUniversal(false, 16)));
                    continue block9;
                }
                case 32: {
                    this.c(aSN1TaggedObject2);
                    continue block9;
                }
                case 76: {
                    this.a(new CertificateHolderAuthorization(aSN1TaggedObject2));
                    continue block9;
                }
                case 37: {
                    this.e(aSN1TaggedObject2);
                    continue block9;
                }
                case 36: {
                    this.f(aSN1TaggedObject2);
                    continue block9;
                }
                default: {
                    this.h = 0;
                    throw new IOException("Not a valid iso7816 ASN1TaggedObject tag " + aSN1TaggedObject2.getTagNo());
                }
            }
        }
    }

    public CertificateBody(ASN1TaggedObject certificateProfileIdentifier, CertificationAuthorityReference certificationAuthorityReference, PublicKeyDataObject publicKey, CertificateHolderReference certificateHolderReference, CertificateHolderAuthorization certificateHolderAuthorization, PackedDate certificateEffectiveDate, PackedDate certificateExpirationDate) {
        this.b(certificateProfileIdentifier);
        this.d(com.enterprisedt.bouncycastle.asn1.eac.a.a(2, certificationAuthorityReference.getEncoded()));
        this.a(publicKey);
        this.c(com.enterprisedt.bouncycastle.asn1.eac.a.a(32, certificateHolderReference.getEncoded()));
        this.a(certificateHolderAuthorization);
        this.e(com.enterprisedt.bouncycastle.asn1.eac.a.a(37, certificateEffectiveDate.getEncoding()));
        this.f(com.enterprisedt.bouncycastle.asn1.eac.a.a(36, certificateExpirationDate.getEncoding()));
    }

    private CertificateBody(ASN1TaggedObject obj) throws IOException {
        this.a(obj);
    }

    private ASN1Primitive a() throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(7);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(com.enterprisedt.bouncycastle.asn1.eac.a.a(73, this.c));
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.e);
        aSN1EncodableVector.add(this.f);
        aSN1EncodableVector.add(this.g);
        return com.enterprisedt.bouncycastle.asn1.eac.a.a(78, new DERSequence(aSN1EncodableVector));
    }

    private void b(ASN1TaggedObject aSN1TaggedObject) throws IllegalArgumentException {
        if (aSN1TaggedObject.hasTag(64, 41)) {
            this.a = aSN1TaggedObject;
            this.h |= 1;
        } else {
            throw new IllegalArgumentException("Not an Iso7816Tags.INTERCHANGE_PROFILE tag :" + aSN1TaggedObject.getTagNo());
        }
    }

    private void c(ASN1TaggedObject aSN1TaggedObject) throws IllegalArgumentException {
        if (aSN1TaggedObject.hasTag(64, 32)) {
            this.d = aSN1TaggedObject;
            this.h |= 8;
        } else {
            throw new IllegalArgumentException("Not an Iso7816Tags.CARDHOLDER_NAME tag");
        }
    }

    private void d(ASN1TaggedObject aSN1TaggedObject) throws IllegalArgumentException {
        if (aSN1TaggedObject.hasTag(64, 2)) {
            this.b = aSN1TaggedObject;
            this.h |= 2;
        } else {
            throw new IllegalArgumentException("Not an Iso7816Tags.ISSUER_IDENTIFICATION_NUMBER tag");
        }
    }

    private void a(PublicKeyDataObject publicKeyDataObject) {
        this.c = PublicKeyDataObject.getInstance(publicKeyDataObject);
        this.h |= 4;
    }

    private ASN1Primitive b() throws IOException {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        aSN1EncodableVector.add(com.enterprisedt.bouncycastle.asn1.eac.a.a(73, this.c));
        aSN1EncodableVector.add(this.d);
        return com.enterprisedt.bouncycastle.asn1.eac.a.a(78, new DERSequence(aSN1EncodableVector));
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        try {
            if ((this.h & 0xFFFFFFFF) == 127) {
                return this.a();
            }
            if ((this.h & 0xFFFFFFFD) == 13) {
                return this.b();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public int getCertificateType() {
        return this.h;
    }

    public static CertificateBody getInstance(Object obj) throws IOException {
        if (obj instanceof CertificateBody) {
            return (CertificateBody)obj;
        }
        if (obj != null) {
            return new CertificateBody(ASN1TaggedObject.getInstance(obj, 64));
        }
        return null;
    }

    public PackedDate getCertificateEffectiveDate() {
        if ((this.h & 0x20) == 32) {
            return new PackedDate(ASN1OctetString.getInstance(this.f.getBaseUniversal(false, 4)).getOctets());
        }
        return null;
    }

    private void e(ASN1TaggedObject aSN1TaggedObject) throws IllegalArgumentException {
        if (aSN1TaggedObject.hasTag(64, 37)) {
            this.f = aSN1TaggedObject;
            this.h |= 0x20;
        } else {
            throw new IllegalArgumentException("Not an Iso7816Tags.APPLICATION_EFFECTIVE_DATE tag :" + aSN1TaggedObject.getTagNo());
        }
    }

    public PackedDate getCertificateExpirationDate() throws IOException {
        if ((this.h & 0x40) == 64) {
            return new PackedDate(ASN1OctetString.getInstance(this.g.getBaseUniversal(false, 4)).getOctets());
        }
        throw new IOException("certificate Expiration Date not set");
    }

    private void f(ASN1TaggedObject aSN1TaggedObject) throws IllegalArgumentException {
        if (aSN1TaggedObject.hasTag(64, 36)) {
            this.g = aSN1TaggedObject;
            this.h |= 0x40;
        } else {
            throw new IllegalArgumentException("Not an Iso7816Tags.APPLICATION_EXPIRATION_DATE tag");
        }
    }

    public CertificateHolderAuthorization getCertificateHolderAuthorization() throws IOException {
        if ((this.h & 0x10) == 16) {
            return this.e;
        }
        throw new IOException("Certificate Holder Authorisation not set");
    }

    private void a(CertificateHolderAuthorization certificateHolderAuthorization) {
        this.e = certificateHolderAuthorization;
        this.h |= 0x10;
    }

    public CertificateHolderReference getCertificateHolderReference() {
        return new CertificateHolderReference(ASN1OctetString.getInstance(this.d.getBaseUniversal(false, 4)).getOctets());
    }

    public ASN1TaggedObject getCertificateProfileIdentifier() {
        return this.a;
    }

    public CertificationAuthorityReference getCertificationAuthorityReference() throws IOException {
        if ((this.h & 2) == 2) {
            return new CertificationAuthorityReference(ASN1OctetString.getInstance(this.b.getBaseUniversal(false, 4)).getOctets());
        }
        throw new IOException("Certification authority reference not set");
    }

    public PublicKeyDataObject getPublicKey() {
        return this.c;
    }
}

