/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.eac;

import java.io.UnsupportedEncodingException;

public class CertificateHolderReference {
    private String a;
    private String b;
    private String c;

    public CertificateHolderReference(String countryCode, String holderMnemonic, String sequenceNumber) {
        this.a = countryCode;
        this.b = holderMnemonic;
        this.c = sequenceNumber;
    }

    CertificateHolderReference(byte[] contents) {
        try {
            String string = new String(contents, "ISO-8859-1");
            this.a = string.substring(0, 2);
            this.b = string.substring(2, string.length() - 5);
            this.c = string.substring(string.length() - 5);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException.toString());
        }
    }

    public String getCountryCode() {
        return this.a;
    }

    public String getHolderMnemonic() {
        return this.b;
    }

    public String getSequenceNumber() {
        return this.c;
    }

    public byte[] getEncoded() {
        String string = this.a + this.b + this.c;
        try {
            return string.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException.toString());
        }
    }
}

