/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.eac;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import java.math.BigInteger;

public class UnsignedInteger
extends ASN1Object {
    private int a;
    private BigInteger b;

    public UnsignedInteger(int tagNo, BigInteger value) {
        this.a = tagNo;
        this.b = value;
    }

    private UnsignedInteger(ASN1TaggedObject obj) {
        this.a = obj.getTagNo();
        this.b = new BigInteger(1, ASN1OctetString.getInstance(obj, false).getOctets());
    }

    public static UnsignedInteger getInstance(Object obj) {
        if (obj instanceof UnsignedInteger) {
            return (UnsignedInteger)obj;
        }
        if (obj != null) {
            return new UnsignedInteger(ASN1TaggedObject.getInstance(obj));
        }
        return null;
    }

    private byte[] a() {
        byte[] byArray = this.b.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public int getTagNo() {
        return this.a;
    }

    public BigInteger getValue() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(false, this.a, (ASN1Encodable)new DEROctetString(this.a()));
    }
}

