/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.esf;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;

public class CommitmentTypeIndication
extends ASN1Object {
    private ASN1ObjectIdentifier a;
    private ASN1Sequence b;

    private CommitmentTypeIndication(ASN1Sequence seq) {
        this.a = (ASN1ObjectIdentifier)seq.getObjectAt(0);
        if (seq.size() > 1) {
            this.b = (ASN1Sequence)seq.getObjectAt(1);
        }
    }

    public CommitmentTypeIndication(ASN1ObjectIdentifier commitmentTypeId) {
        this.a = commitmentTypeId;
    }

    public CommitmentTypeIndication(ASN1ObjectIdentifier commitmentTypeId, ASN1Sequence commitmentTypeQualifier) {
        this.a = commitmentTypeId;
        this.b = commitmentTypeQualifier;
    }

    public static CommitmentTypeIndication getInstance(Object obj) {
        if (obj == null || obj instanceof CommitmentTypeIndication) {
            return (CommitmentTypeIndication)obj;
        }
        return new CommitmentTypeIndication(ASN1Sequence.getInstance(obj));
    }

    public ASN1ObjectIdentifier getCommitmentTypeId() {
        return this.a;
    }

    public ASN1Sequence getCommitmentTypeQualifier() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

