/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.esf;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1UTCTime;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import java.math.BigInteger;

public class CrlIdentifier
extends ASN1Object {
    private X500Name a;
    private ASN1UTCTime b;
    private ASN1Integer c;

    public static CrlIdentifier getInstance(Object obj) {
        if (obj instanceof CrlIdentifier) {
            return (CrlIdentifier)obj;
        }
        if (obj != null) {
            return new CrlIdentifier(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private CrlIdentifier(ASN1Sequence seq) {
        if (seq.size() < 2 || seq.size() > 3) {
            throw new IllegalArgumentException();
        }
        this.a = X500Name.getInstance(seq.getObjectAt(0));
        this.b = ASN1UTCTime.getInstance(seq.getObjectAt(1));
        if (seq.size() > 2) {
            this.c = ASN1Integer.getInstance(seq.getObjectAt(2));
        }
    }

    public CrlIdentifier(X500Name crlIssuer, ASN1UTCTime crlIssuedTime) {
        this(crlIssuer, crlIssuedTime, null);
    }

    public CrlIdentifier(X500Name crlIssuer, ASN1UTCTime crlIssuedTime, BigInteger crlNumber) {
        this.a = crlIssuer;
        this.b = crlIssuedTime;
        if (null != crlNumber) {
            this.c = new ASN1Integer(crlNumber);
        }
    }

    public X500Name getCrlIssuer() {
        return this.a;
    }

    public ASN1UTCTime getCrlIssuedTime() {
        return this.b;
    }

    public BigInteger getCrlNumber() {
        if (null == this.c) {
            return null;
        }
        return this.c.getValue();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(this.a.toASN1Primitive());
        aSN1EncodableVector.add(this.b);
        if (null != this.c) {
            aSN1EncodableVector.add(this.c);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

