/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.esf;

import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.esf.OcspResponsesID;
import java.util.Enumeration;

public class OcspListID
extends ASN1Object {
    private ASN1Sequence a;

    public static OcspListID getInstance(Object obj) {
        if (obj instanceof OcspListID) {
            return (OcspListID)obj;
        }
        if (obj != null) {
            return new OcspListID(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private OcspListID(ASN1Sequence seq) {
        if (seq.size() != 1) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.a = (ASN1Sequence)seq.getObjectAt(0);
        Enumeration enumeration = this.a.getObjects();
        while (enumeration.hasMoreElements()) {
            OcspResponsesID.getInstance(enumeration.nextElement());
        }
    }

    public OcspListID(OcspResponsesID[] ocspResponses) {
        this.a = new DERSequence(ocspResponses);
    }

    public OcspResponsesID[] getOcspResponses() {
        OcspResponsesID[] ocspResponsesIDArray = new OcspResponsesID[this.a.size()];
        for (int i2 = 0; i2 < ocspResponsesIDArray.length; ++i2) {
            ocspResponsesIDArray[i2] = OcspResponsesID.getInstance(this.a.getObjectAt(i2));
        }
        return ocspResponsesIDArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.a);
    }
}

