/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.esf;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.Attribute;
import com.enterprisedt.bouncycastle.asn1.x509.AttributeCertificate;
import java.util.Enumeration;

public class SignerAttribute
extends ASN1Object {
    private Object[] a;

    public static SignerAttribute getInstance(Object o2) {
        if (o2 instanceof SignerAttribute) {
            return (SignerAttribute)o2;
        }
        if (o2 != null) {
            return new SignerAttribute(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private SignerAttribute(ASN1Sequence seq) {
        int n2 = 0;
        this.a = new Object[seq.size()];
        Enumeration enumeration = seq.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(enumeration.nextElement());
            if (aSN1TaggedObject.getTagNo() == 0) {
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1TaggedObject, true);
                Attribute[] attributeArray = new Attribute[aSN1Sequence.size()];
                for (int i2 = 0; i2 != attributeArray.length; ++i2) {
                    attributeArray[i2] = Attribute.getInstance(aSN1Sequence.getObjectAt(i2));
                }
                this.a[n2] = attributeArray;
            } else if (aSN1TaggedObject.getTagNo() == 1) {
                this.a[n2] = AttributeCertificate.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, true));
            } else {
                throw new IllegalArgumentException("illegal tag: " + aSN1TaggedObject.getTagNo());
            }
            ++n2;
        }
    }

    public SignerAttribute(Attribute[] claimedAttributes) {
        this.a = new Object[1];
        this.a[0] = claimedAttributes;
    }

    public SignerAttribute(AttributeCertificate certifiedAttributes) {
        this.a = new Object[1];
        this.a[0] = certifiedAttributes;
    }

    public Object[] getValues() {
        Object[] objectArray = new Object[this.a.length];
        System.arraycopy(this.a, 0, objectArray, 0, objectArray.length);
        return objectArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(this.a.length);
        for (int i2 = 0; i2 != this.a.length; ++i2) {
            if (this.a[i2] instanceof Attribute[]) {
                aSN1EncodableVector.add(new DERTaggedObject(0, new DERSequence((Attribute[])this.a[i2])));
                continue;
            }
            aSN1EncodableVector.add(new DERTaggedObject(1, (AttributeCertificate)this.a[i2]));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

