/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.ess;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.IssuerSerial;
import com.enterprisedt.bouncycastle.util.Arrays;

public class ESSCertID
extends ASN1Object {
    private ASN1OctetString a;
    private IssuerSerial b;

    public static ESSCertID getInstance(Object o2) {
        if (o2 instanceof ESSCertID) {
            return (ESSCertID)o2;
        }
        if (o2 != null) {
            return new ESSCertID(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private ESSCertID(ASN1Sequence seq) {
        if (seq.size() < 1 || seq.size() > 2) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        this.a = ASN1OctetString.getInstance(seq.getObjectAt(0));
        if (seq.size() > 1) {
            this.b = IssuerSerial.getInstance(seq.getObjectAt(1));
        }
    }

    public ESSCertID(byte[] hash) {
        this.a = new DEROctetString(Arrays.clone(hash));
    }

    public ESSCertID(byte[] hash, IssuerSerial issuerSerial) {
        this.a = new DEROctetString(Arrays.clone(hash));
        this.b = issuerSerial;
    }

    public byte[] getCertHash() {
        return this.a.getOctets();
    }

    public IssuerSerial getIssuerSerial() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

