/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.est;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.pkcs.Attribute;
import java.io.IOException;

public class AttrOrOID
extends ASN1Object
implements ASN1Choice {
    private final ASN1ObjectIdentifier a;
    private final Attribute b;

    public AttrOrOID(ASN1ObjectIdentifier oid) {
        this.a = oid;
        this.b = null;
    }

    public AttrOrOID(Attribute attribute) {
        this.a = null;
        this.b = attribute;
    }

    public static AttrOrOID getInstance(Object obj) {
        if (obj instanceof AttrOrOID) {
            return (AttrOrOID)obj;
        }
        if (obj != null) {
            if (obj instanceof ASN1Encodable) {
                ASN1Primitive aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive();
                if (aSN1Primitive instanceof ASN1ObjectIdentifier) {
                    return new AttrOrOID(ASN1ObjectIdentifier.getInstance(aSN1Primitive));
                }
                if (aSN1Primitive instanceof ASN1Sequence) {
                    return new AttrOrOID(Attribute.getInstance(aSN1Primitive));
                }
            }
            if (obj instanceof byte[]) {
                try {
                    return AttrOrOID.getInstance(ASN1Primitive.fromByteArray((byte[])obj));
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("unknown encoding in getInstance()");
                }
            }
            throw new IllegalArgumentException("unknown object in getInstance(): " + obj.getClass().getName());
        }
        return null;
    }

    public boolean isOid() {
        return this.a != null;
    }

    public ASN1ObjectIdentifier getOid() {
        return this.a;
    }

    public Attribute getAttribute() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (this.a != null) {
            return this.a;
        }
        return this.b.toASN1Primitive();
    }
}

