/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.nist;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.util.Arrays;

public class KMACwithSHAKE128_params
extends ASN1Object {
    private static final byte[] a = new byte[0];
    private final int b;
    private final byte[] c;

    public KMACwithSHAKE128_params(int outputLength) {
        this.b = outputLength;
        this.c = a;
    }

    public KMACwithSHAKE128_params(int outputLength, byte[] customizationString) {
        this.b = outputLength;
        this.c = Arrays.clone(customizationString);
    }

    public static KMACwithSHAKE128_params getInstance(Object o2) {
        if (o2 instanceof KMACwithSHAKE128_params) {
            return (KMACwithSHAKE128_params)o2;
        }
        if (o2 != null) {
            return new KMACwithSHAKE128_params(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    private KMACwithSHAKE128_params(ASN1Sequence seq) {
        if (seq.size() > 2) {
            throw new IllegalArgumentException("sequence size greater than 2");
        }
        if (seq.size() == 2) {
            this.b = ASN1Integer.getInstance(seq.getObjectAt(0)).intValueExact();
            this.c = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(1)).getOctets());
        } else if (seq.size() == 1) {
            if (seq.getObjectAt(0) instanceof ASN1Integer) {
                this.b = ASN1Integer.getInstance(seq.getObjectAt(0)).intValueExact();
                this.c = a;
            } else {
                this.b = 256;
                this.c = Arrays.clone(ASN1OctetString.getInstance(seq.getObjectAt(0)).getOctets());
            }
        } else {
            this.b = 256;
            this.c = a;
        }
    }

    public int getOutputLength() {
        return this.b;
    }

    public byte[] getCustomizationString() {
        return Arrays.clone(this.c);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (this.b != 256) {
            aSN1EncodableVector.add(new ASN1Integer(this.b));
        }
        if (this.c.length != 0) {
            aSN1EncodableVector.add(new DEROctetString(this.getCustomizationString()));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

