/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.ocsp;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.ocsp.ResponderID;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.X509Extensions;

public class ResponseData
extends ASN1Object {
    private static final ASN1Integer a = new ASN1Integer(0L);
    private boolean b;
    private ASN1Integer c;
    private ResponderID d;
    private ASN1GeneralizedTime e;
    private ASN1Sequence f;
    private Extensions g;

    public ResponseData(ASN1Integer version, ResponderID responderID, ASN1GeneralizedTime producedAt, ASN1Sequence responses, Extensions responseExtensions) {
        this.c = version;
        this.d = responderID;
        this.e = producedAt;
        this.f = responses;
        this.g = responseExtensions;
    }

    public ResponseData(ResponderID responderID, ASN1GeneralizedTime producedAt, ASN1Sequence responses, X509Extensions responseExtensions) {
        this(a, responderID, ASN1GeneralizedTime.getInstance(producedAt), responses, Extensions.getInstance(responseExtensions));
    }

    public ResponseData(ResponderID responderID, ASN1GeneralizedTime producedAt, ASN1Sequence responses, Extensions responseExtensions) {
        this(a, responderID, producedAt, responses, responseExtensions);
    }

    private ResponseData(ASN1Sequence seq) {
        int n2 = 0;
        if (seq.getObjectAt(0) instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)seq.getObjectAt(0);
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.b = true;
                this.c = ASN1Integer.getInstance((ASN1TaggedObject)seq.getObjectAt(0), true);
            } else {
                this.c = a;
            }
        } else {
            this.c = a;
        }
        int n3 = ++n2;
        this.d = ResponderID.getInstance(seq.getObjectAt(n3));
        int n4 = ++n2;
        this.e = ASN1GeneralizedTime.getInstance(seq.getObjectAt(n4));
        int n5 = ++n2;
        this.f = (ASN1Sequence)seq.getObjectAt(n5);
        if (seq.size() > ++n2) {
            this.g = Extensions.getInstance((ASN1TaggedObject)seq.getObjectAt(n2), true);
        }
    }

    public static ResponseData getInstance(ASN1TaggedObject obj, boolean explicit) {
        return ResponseData.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static ResponseData getInstance(Object obj) {
        if (obj instanceof ResponseData) {
            return (ResponseData)obj;
        }
        if (obj != null) {
            return new ResponseData(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public ASN1Integer getVersion() {
        return this.c;
    }

    public ResponderID getResponderID() {
        return this.d;
    }

    public ASN1GeneralizedTime getProducedAt() {
        return this.e;
    }

    public ASN1Sequence getResponses() {
        return this.f;
    }

    public Extensions getResponseExtensions() {
        return this.g;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(5);
        if (this.b || !this.c.equals(a)) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, (ASN1Encodable)this.c));
        }
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.e);
        aSN1EncodableVector.add(this.f);
        if (this.g != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 1, (ASN1Encodable)this.g));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

