/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.ocsp;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class Signature
extends ASN1Object {
    AlgorithmIdentifier a;
    DERBitString b;
    ASN1Sequence c;

    public Signature(AlgorithmIdentifier signatureAlgorithm, DERBitString signature) {
        this.a = signatureAlgorithm;
        this.b = signature;
    }

    public Signature(AlgorithmIdentifier signatureAlgorithm, DERBitString signature, ASN1Sequence certs) {
        this.a = signatureAlgorithm;
        this.b = signature;
        this.c = certs;
    }

    private Signature(ASN1Sequence seq) {
        this.a = AlgorithmIdentifier.getInstance(seq.getObjectAt(0));
        this.b = (DERBitString)seq.getObjectAt(1);
        if (seq.size() == 3) {
            this.c = ASN1Sequence.getInstance((ASN1TaggedObject)seq.getObjectAt(2), true);
        }
    }

    public static Signature getInstance(ASN1TaggedObject obj, boolean explicit) {
        return Signature.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static Signature getInstance(Object obj) {
        if (obj instanceof Signature) {
            return (Signature)obj;
        }
        if (obj != null) {
            return new Signature(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.a;
    }

    public DERBitString getSignature() {
        return this.b;
    }

    public ASN1Sequence getCerts() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, (ASN1Encodable)this.c));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

