/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;

public class CRLBag
extends ASN1Object {
    private ASN1ObjectIdentifier a;
    private ASN1Encodable b;

    private CRLBag(ASN1Sequence seq) {
        this.a = ASN1ObjectIdentifier.getInstance(seq.getObjectAt(0));
        this.b = ASN1TaggedObject.getInstance(seq.getObjectAt(1)).getExplicitBaseObject();
    }

    public static CRLBag getInstance(Object o2) {
        if (o2 instanceof CRLBag) {
            return (CRLBag)o2;
        }
        if (o2 != null) {
            return new CRLBag(ASN1Sequence.getInstance(o2));
        }
        return null;
    }

    public CRLBag(ASN1ObjectIdentifier crlId, ASN1Encodable crlValue) {
        this.a = crlId;
        this.b = crlValue;
    }

    public ASN1ObjectIdentifier getCrlId() {
        return this.a;
    }

    public ASN1Encodable getCrlValue() {
        return this.b;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(new DERTaggedObject(0, this.b));
        return new DERSequence(aSN1EncodableVector);
    }
}

