/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.pkcs;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.util.Enumeration;

public class PrivateKeyInfo
extends ASN1Object {
    private ASN1Integer a;
    private AlgorithmIdentifier b;
    private ASN1OctetString c;
    private ASN1Set d;
    private ASN1BitString e;

    public static PrivateKeyInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return PrivateKeyInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static PrivateKeyInfo getInstance(Object obj) {
        if (obj instanceof PrivateKeyInfo) {
            return (PrivateKeyInfo)obj;
        }
        if (obj != null) {
            return new PrivateKeyInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private static int a(ASN1Integer aSN1Integer) {
        int n2 = aSN1Integer.intValueExact();
        if (n2 < 0 || n2 > 1) {
            throw new IllegalArgumentException("invalid version for private key info");
        }
        return n2;
    }

    public PrivateKeyInfo(AlgorithmIdentifier privateKeyAlgorithm, ASN1Encodable privateKey) throws IOException {
        this(privateKeyAlgorithm, privateKey, null, null);
    }

    public PrivateKeyInfo(AlgorithmIdentifier privateKeyAlgorithm, ASN1Encodable privateKey, ASN1Set attributes) throws IOException {
        this(privateKeyAlgorithm, privateKey, attributes, null);
    }

    public PrivateKeyInfo(AlgorithmIdentifier privateKeyAlgorithm, ASN1Encodable privateKey, ASN1Set attributes, byte[] publicKey) throws IOException {
        this.a = new ASN1Integer(publicKey != null ? BigIntegers.ONE : BigIntegers.ZERO);
        this.b = privateKeyAlgorithm;
        this.c = new DEROctetString(privateKey);
        this.d = attributes;
        this.e = publicKey == null ? null : new DERBitString(publicKey);
    }

    private PrivateKeyInfo(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        this.a = ASN1Integer.getInstance(enumeration.nextElement());
        int n2 = PrivateKeyInfo.a(this.a);
        this.b = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        this.c = ASN1OctetString.getInstance(enumeration.nextElement());
        int n3 = -1;
        block4: while (enumeration.hasMoreElements()) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)enumeration.nextElement();
            int n4 = aSN1TaggedObject.getTagNo();
            if (n4 <= n3) {
                throw new IllegalArgumentException("invalid optional field in private key info");
            }
            n3 = n4;
            switch (n4) {
                case 0: {
                    this.d = ASN1Set.getInstance(aSN1TaggedObject, false);
                    continue block4;
                }
                case 1: {
                    if (n2 < 1) {
                        throw new IllegalArgumentException("'publicKey' requires version v2(1) or later");
                    }
                    this.e = ASN1BitString.getInstance(aSN1TaggedObject, false);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("unknown optional field in private key info");
        }
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public ASN1Set getAttributes() {
        return this.d;
    }

    public AlgorithmIdentifier getPrivateKeyAlgorithm() {
        return this.b;
    }

    public ASN1OctetString getPrivateKey() {
        return new DEROctetString(this.c.getOctets());
    }

    public int getPrivateKeyLength() {
        return this.c.getOctetsLength();
    }

    public ASN1Encodable parsePrivateKey() throws IOException {
        return ASN1Primitive.fromByteArray(this.c.getOctets());
    }

    public boolean hasPublicKey() {
        return this.e != null;
    }

    public ASN1Encodable parsePublicKey() throws IOException {
        return this.e == null ? null : ASN1Primitive.fromByteArray(this.e.getOctets());
    }

    public ASN1BitString getPublicKeyData() {
        return this.e;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(5);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, (ASN1Encodable)this.d));
        }
        if (this.e != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, (ASN1Encodable)this.e));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

