/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x500;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Set;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSet;
import com.enterprisedt.bouncycastle.asn1.x500.AttributeTypeAndValue;

public class RDN
extends ASN1Object {
    private ASN1Set a;

    private RDN(ASN1Set values) {
        this.a = values;
    }

    public static RDN getInstance(Object obj) {
        if (obj instanceof RDN) {
            return (RDN)obj;
        }
        if (obj != null) {
            return new RDN(ASN1Set.getInstance(obj));
        }
        return null;
    }

    public static RDN getInstance(ASN1TaggedObject taggedObject, boolean declaredExplicit) {
        return new RDN(ASN1Set.getInstance(taggedObject, declaredExplicit));
    }

    public RDN(ASN1ObjectIdentifier oid, ASN1Encodable value) {
        this(new AttributeTypeAndValue(oid, value));
    }

    public RDN(AttributeTypeAndValue attrTAndV) {
        this.a = new DERSet(attrTAndV);
    }

    public RDN(AttributeTypeAndValue[] aAndVs) {
        this.a = new DERSet(aAndVs);
    }

    public boolean isMultiValued() {
        return this.a.size() > 1;
    }

    public int size() {
        return this.a.size();
    }

    public AttributeTypeAndValue getFirst() {
        if (this.a.size() == 0) {
            return null;
        }
        return AttributeTypeAndValue.getInstance(this.a.getObjectAt(0));
    }

    public AttributeTypeAndValue[] getTypesAndValues() {
        AttributeTypeAndValue[] attributeTypeAndValueArray = new AttributeTypeAndValue[this.a.size()];
        for (int i2 = 0; i2 != attributeTypeAndValueArray.length; ++i2) {
            attributeTypeAndValueArray[i2] = AttributeTypeAndValue.getInstance(this.a.getObjectAt(i2));
        }
        return attributeTypeAndValueArray;
    }

    int a(ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray, int n2) {
        int n3 = this.a.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            AttributeTypeAndValue attributeTypeAndValue = AttributeTypeAndValue.getInstance(this.a.getObjectAt(i2));
            aSN1ObjectIdentifierArray[n2 + i2] = attributeTypeAndValue.getType();
        }
        return n3;
    }

    boolean a(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        int n2 = this.a.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            AttributeTypeAndValue attributeTypeAndValue = AttributeTypeAndValue.getInstance(this.a.getObjectAt(i2));
            if (!attributeTypeAndValue.getType().equals(aSN1ObjectIdentifier)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }
}

