/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x500;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x500.RDN;
import com.enterprisedt.bouncycastle.asn1.x500.X500NameStyle;
import com.enterprisedt.bouncycastle.asn1.x500.style.BCStyle;

public class X500Name
extends ASN1Object
implements ASN1Choice {
    private static X500NameStyle a = BCStyle.INSTANCE;
    private boolean b;
    private int c;
    private X500NameStyle d;
    private RDN[] e;
    private DERSequence f;

    public X500Name(X500NameStyle style, X500Name name) {
        this.d = style;
        this.e = name.e;
        this.f = name.f;
    }

    public static X500Name getInstance(ASN1TaggedObject obj, boolean explicit) {
        return X500Name.getInstance(ASN1Sequence.getInstance(obj, true));
    }

    public static X500Name getInstance(Object obj) {
        if (obj instanceof X500Name) {
            return (X500Name)obj;
        }
        if (obj != null) {
            return new X500Name(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static X500Name getInstance(X500NameStyle style, Object obj) {
        if (obj instanceof X500Name) {
            return new X500Name(style, (X500Name)obj);
        }
        if (obj != null) {
            return new X500Name(style, ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private X500Name(ASN1Sequence seq) {
        this(a, seq);
    }

    private X500Name(X500NameStyle style, ASN1Sequence seq) {
        int n2 = seq.size();
        this.d = style;
        this.e = new RDN[n2];
        boolean bl = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            ASN1Encodable aSN1Encodable = seq.getObjectAt(i2);
            RDN rDN = RDN.getInstance(aSN1Encodable);
            bl &= rDN == aSN1Encodable;
            this.e[i2] = rDN;
        }
        this.f = bl ? DERSequence.convert(seq) : new DERSequence(this.e);
    }

    public X500Name(RDN[] rDNs) {
        this(a, rDNs);
    }

    public X500Name(X500NameStyle style, RDN[] rDNs) {
        this.d = style;
        this.e = (RDN[])rDNs.clone();
        this.f = new DERSequence(this.e);
    }

    public X500Name(String dirName) {
        this(a, dirName);
    }

    public X500Name(X500NameStyle style, String dirName) {
        this(style.fromString(dirName));
        this.d = style;
    }

    public RDN[] getRDNs() {
        return (RDN[])this.e.clone();
    }

    public ASN1ObjectIdentifier[] getAttributeTypes() {
        int n2 = this.e.length;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            RDN rDN = this.e[i2];
            n3 += rDN.size();
        }
        ASN1ObjectIdentifier[] aSN1ObjectIdentifierArray = new ASN1ObjectIdentifier[n3];
        int n4 = 0;
        for (int i3 = 0; i3 < n2; ++i3) {
            RDN rDN = this.e[i3];
            n4 += rDN.a(aSN1ObjectIdentifierArray, n4);
        }
        return aSN1ObjectIdentifierArray;
    }

    public RDN[] getRDNs(ASN1ObjectIdentifier attributeType) {
        RDN[] rDNArray = new RDN[this.e.length];
        int n2 = 0;
        for (int i2 = 0; i2 != this.e.length; ++i2) {
            RDN rDN = this.e[i2];
            if (!rDN.a(attributeType)) continue;
            rDNArray[n2++] = rDN;
        }
        if (n2 < rDNArray.length) {
            RDN[] rDNArray2 = new RDN[n2];
            System.arraycopy(rDNArray, 0, rDNArray2, 0, rDNArray2.length);
            rDNArray = rDNArray2;
        }
        return rDNArray;
    }

    public int size() {
        return this.e.length;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.f;
    }

    @Override
    public int hashCode() {
        if (this.b) {
            return this.c;
        }
        this.b = true;
        this.c = this.d.calculateHashCode(this);
        return this.c;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof X500Name) && !(obj instanceof ASN1Sequence)) {
            return false;
        }
        ASN1Primitive aSN1Primitive = ((ASN1Encodable)obj).toASN1Primitive();
        if (this.toASN1Primitive().equals(aSN1Primitive)) {
            return true;
        }
        try {
            return this.d.areEqual(this, X500Name.getInstance(obj));
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toString() {
        return this.d.toString(this);
    }

    public static void setDefaultStyle(X500NameStyle style) {
        if (style == null) {
            throw new NullPointerException("cannot set style to null");
        }
        a = style;
    }

    public static X500NameStyle getDefaultStyle() {
        return a;
    }
}

