/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.DistributionPoint;
import com.enterprisedt.bouncycastle.asn1.x509.Extension;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.util.Strings;

public class CRLDistPoint
extends ASN1Object {
    ASN1Sequence a = null;

    public static CRLDistPoint getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CRLDistPoint.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static CRLDistPoint getInstance(Object obj) {
        if (obj instanceof CRLDistPoint) {
            return (CRLDistPoint)obj;
        }
        if (obj != null) {
            return new CRLDistPoint(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static CRLDistPoint fromExtensions(Extensions extensions) {
        return CRLDistPoint.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.cRLDistributionPoints));
    }

    private CRLDistPoint(ASN1Sequence seq) {
        this.a = seq;
    }

    public CRLDistPoint(DistributionPoint[] points) {
        this.a = new DERSequence(points);
    }

    public DistributionPoint[] getDistributionPoints() {
        DistributionPoint[] distributionPointArray = new DistributionPoint[this.a.size()];
        for (int i2 = 0; i2 != this.a.size(); ++i2) {
            distributionPointArray[i2] = DistributionPoint.getInstance(this.a.getObjectAt(i2));
        }
        return distributionPointArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Strings.lineSeparator();
        stringBuffer.append("CRLDistPoint:");
        stringBuffer.append(string);
        DistributionPoint[] distributionPointArray = this.getDistributionPoints();
        for (int i2 = 0; i2 != distributionPointArray.length; ++i2) {
            stringBuffer.append("    ");
            stringBuffer.append(distributionPointArray[i2]);
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

