/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.TBSCertList;
import com.enterprisedt.bouncycastle.asn1.x509.Time;
import java.util.Enumeration;

public class CertificateList
extends ASN1Object {
    TBSCertList a;
    AlgorithmIdentifier b;
    ASN1BitString c;
    boolean d = false;
    int e;

    public static CertificateList getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertificateList.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static CertificateList getInstance(Object obj) {
        if (obj instanceof CertificateList) {
            return (CertificateList)obj;
        }
        if (obj != null) {
            return new CertificateList(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private CertificateList(ASN1Sequence seq) {
        if (seq.size() != 3) {
            throw new IllegalArgumentException("sequence wrong size for CertificateList");
        }
        this.a = TBSCertList.getInstance(seq.getObjectAt(0));
        this.b = AlgorithmIdentifier.getInstance(seq.getObjectAt(1));
        this.c = ASN1BitString.getInstance(seq.getObjectAt(2));
    }

    public TBSCertList getTBSCertList() {
        return this.a;
    }

    public TBSCertList.CRLEntry[] getRevokedCertificates() {
        return this.a.getRevokedCertificates();
    }

    public Enumeration getRevokedCertificateEnumeration() {
        return this.a.getRevokedCertificateEnumeration();
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.b;
    }

    public ASN1BitString getSignature() {
        return this.c;
    }

    public int getVersionNumber() {
        return this.a.getVersionNumber();
    }

    public X500Name getIssuer() {
        return this.a.getIssuer();
    }

    public Time getThisUpdate() {
        return this.a.getThisUpdate();
    }

    public Time getNextUpdate() {
        return this.a.getNextUpdate();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        return new DERSequence(aSN1EncodableVector);
    }

    @Override
    public int hashCode() {
        if (!this.d) {
            this.e = super.hashCode();
            this.d = true;
        }
        return this.e;
    }
}

