/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.Extension;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.PolicyInformation;

public class CertificatePolicies
extends ASN1Object {
    private final PolicyInformation[] a;

    private static PolicyInformation[] a(PolicyInformation[] policyInformationArray) {
        PolicyInformation[] policyInformationArray2 = new PolicyInformation[policyInformationArray.length];
        System.arraycopy(policyInformationArray, 0, policyInformationArray2, 0, policyInformationArray.length);
        return policyInformationArray2;
    }

    public static CertificatePolicies getInstance(Object obj) {
        if (obj instanceof CertificatePolicies) {
            return (CertificatePolicies)obj;
        }
        if (obj != null) {
            return new CertificatePolicies(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static CertificatePolicies getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CertificatePolicies.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static CertificatePolicies fromExtensions(Extensions extensions) {
        return CertificatePolicies.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.certificatePolicies));
    }

    public CertificatePolicies(PolicyInformation name) {
        this.a = new PolicyInformation[]{name};
    }

    public CertificatePolicies(PolicyInformation[] policyInformation) {
        this.a = CertificatePolicies.a(policyInformation);
    }

    private CertificatePolicies(ASN1Sequence seq) {
        this.a = new PolicyInformation[seq.size()];
        for (int i2 = 0; i2 != seq.size(); ++i2) {
            this.a[i2] = PolicyInformation.getInstance(seq.getObjectAt(i2));
        }
    }

    public PolicyInformation[] getPolicyInformation() {
        return CertificatePolicies.a(this.a);
    }

    public PolicyInformation getPolicyInformation(ASN1ObjectIdentifier policyIdentifier) {
        for (int i2 = 0; i2 != this.a.length; ++i2) {
            if (!policyIdentifier.equals(this.a[i2].getPolicyIdentifier())) continue;
            return this.a[i2];
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.a);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.a[i2]);
        }
        return "CertificatePolicies: [" + stringBuffer + "]";
    }
}

