/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.Extension;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.ExtensionsGenerator;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.asn1.x509.TBSCertificate;
import java.util.Enumeration;

public class DeltaCertificateDescriptor
extends ASN1Object {
    private final ASN1Integer a;
    private AlgorithmIdentifier b;
    private X500Name c;
    private ASN1Sequence d;
    private X500Name e;
    private SubjectPublicKeyInfo f;
    private Extensions g;
    private final ASN1BitString h;

    public static DeltaCertificateDescriptor getInstance(Object obj) {
        if (obj instanceof DeltaCertificateDescriptor) {
            return (DeltaCertificateDescriptor)obj;
        }
        if (obj != null) {
            return new DeltaCertificateDescriptor(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static DeltaCertificateDescriptor fromExtensions(Extensions extensions) {
        return DeltaCertificateDescriptor.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.deltaCertificateDescriptor));
    }

    private DeltaCertificateDescriptor(ASN1Sequence seq) {
        ASN1TaggedObject aSN1TaggedObject;
        this.a = ASN1Integer.getInstance(seq.getObjectAt(0));
        int n2 = 1;
        ASN1Encodable aSN1Encodable = seq.getObjectAt(n2);
        while (aSN1Encodable instanceof ASN1TaggedObject) {
            aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Encodable);
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    this.b = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
                    break;
                }
                case 1: {
                    this.c = X500Name.getInstance(aSN1TaggedObject, true);
                    break;
                }
                case 2: {
                    this.d = ASN1Sequence.getInstance(aSN1TaggedObject, false);
                    break;
                }
                case 3: {
                    this.e = X500Name.getInstance(aSN1TaggedObject, true);
                }
            }
            aSN1Encodable = seq.getObjectAt(n2++);
        }
        this.f = SubjectPublicKeyInfo.getInstance(aSN1Encodable);
        aSN1Encodable = seq.getObjectAt(n2);
        while (aSN1Encodable instanceof ASN1TaggedObject) {
            aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Encodable);
            switch (aSN1TaggedObject.getTagNo()) {
                case 4: {
                    this.g = Extensions.getInstance(aSN1TaggedObject, false);
                }
            }
            aSN1Encodable = seq.getObjectAt(n2++);
        }
        this.h = ASN1BitString.getInstance(aSN1Encodable);
    }

    public ASN1Integer getSerialNumber() {
        return this.a;
    }

    public AlgorithmIdentifier getSignature() {
        return this.b;
    }

    public X500Name getIssuer() {
        return this.c;
    }

    public ASN1Sequence getValidity() {
        return this.d;
    }

    public X500Name getSubject() {
        return this.e;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.f;
    }

    public Extensions getExtensions() {
        return this.g;
    }

    public ASN1BitString getSignatureValue() {
        return this.h;
    }

    public DeltaCertificateDescriptor trimTo(TBSCertificate baseTbsCertificate, Extensions tbsExtensions) {
        ASN1Object aSN1Object;
        Object object;
        Object object2;
        ASN1Object aSN1Object2;
        ASN1TaggedObject aSN1TaggedObject;
        AlgorithmIdentifier algorithmIdentifier = baseTbsCertificate.d;
        X500Name x500Name = baseTbsCertificate.e;
        DERSequence dERSequence = new DERSequence(new ASN1Encodable[]{baseTbsCertificate.f, baseTbsCertificate.g});
        X500Name x500Name2 = baseTbsCertificate.h;
        ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(this.toASN1Primitive());
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        Enumeration enumeration = aSN1Sequence.getObjects();
        aSN1EncodableVector.add((ASN1Encodable)enumeration.nextElement());
        ASN1Encodable aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
        while (aSN1Encodable instanceof ASN1TaggedObject) {
            aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Encodable);
            switch (aSN1TaggedObject.getTagNo()) {
                case 0: {
                    aSN1Object2 = AlgorithmIdentifier.getInstance(aSN1TaggedObject, false);
                    if (aSN1Object2.equals(algorithmIdentifier)) break;
                    aSN1EncodableVector.add(aSN1Encodable);
                    break;
                }
                case 1: {
                    object2 = X500Name.getInstance(aSN1TaggedObject, true);
                    if (((X500Name)object2).equals(x500Name)) break;
                    aSN1EncodableVector.add(aSN1Encodable);
                    break;
                }
                case 2: {
                    object = ASN1Sequence.getInstance(aSN1TaggedObject, false);
                    if (((ASN1Primitive)object).equals(dERSequence)) break;
                    aSN1EncodableVector.add(aSN1Encodable);
                    break;
                }
                case 3: {
                    aSN1Object = X500Name.getInstance(aSN1TaggedObject, true);
                    if (((X500Name)aSN1Object).equals(x500Name2)) break;
                    aSN1EncodableVector.add(aSN1Encodable);
                }
            }
            aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
        }
        aSN1EncodableVector.add(aSN1Encodable);
        aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
        while (aSN1Encodable instanceof ASN1TaggedObject) {
            aSN1TaggedObject = ASN1TaggedObject.getInstance(aSN1Encodable);
            switch (aSN1TaggedObject.getTagNo()) {
                case 4: {
                    aSN1Object2 = Extensions.getInstance(aSN1TaggedObject, false);
                    object2 = new ExtensionsGenerator();
                    object = ((Extensions)aSN1Object2).oids();
                    while (object.hasMoreElements()) {
                        aSN1Object = ((Extensions)aSN1Object2).getExtension((ASN1ObjectIdentifier)object.nextElement());
                        Extension extension = tbsExtensions.getExtension(((Extension)aSN1Object).getExtnId());
                        if (extension == null || ((Extension)aSN1Object).equals(extension)) continue;
                        ((ExtensionsGenerator)object2).addExtension((Extension)aSN1Object);
                    }
                    if (((ExtensionsGenerator)object2).isEmpty()) break;
                    aSN1EncodableVector.add(new DERTaggedObject(false, 4, (ASN1Encodable)((ExtensionsGenerator)object2).generate()));
                }
            }
            aSN1Encodable = (ASN1Encodable)enumeration.nextElement();
        }
        aSN1EncodableVector.add(aSN1Encodable);
        return new DeltaCertificateDescriptor(new DERSequence(aSN1EncodableVector));
    }

    private void a(ASN1EncodableVector aSN1EncodableVector, int n2, boolean bl, ASN1Object aSN1Object) {
        if (aSN1Object != null) {
            aSN1EncodableVector.add(new DERTaggedObject(bl, n2, (ASN1Encodable)aSN1Object));
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(7);
        aSN1EncodableVector.add(this.a);
        this.a(aSN1EncodableVector, 0, false, this.b);
        this.a(aSN1EncodableVector, 1, true, this.c);
        this.a(aSN1EncodableVector, 2, false, this.d);
        this.a(aSN1EncodableVector, 3, true, this.e);
        aSN1EncodableVector.add(this.f);
        this.a(aSN1EncodableVector, 4, false, this.g);
        aSN1EncodableVector.add(this.h);
        return new DERSequence(aSN1EncodableVector);
    }
}

