/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.ASN1UTF8String;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralNames;
import java.util.Enumeration;
import java.util.Vector;

public class IetfAttrSyntax
extends ASN1Object {
    public static final int VALUE_OCTETS = 1;
    public static final int VALUE_OID = 2;
    public static final int VALUE_UTF8 = 3;
    GeneralNames a = null;
    Vector b = new Vector();
    int c = -1;

    public static IetfAttrSyntax getInstance(Object obj) {
        if (obj instanceof IetfAttrSyntax) {
            return (IetfAttrSyntax)obj;
        }
        if (obj != null) {
            return new IetfAttrSyntax(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private IetfAttrSyntax(ASN1Sequence seq) {
        int n2 = 0;
        if (seq.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.a = GeneralNames.getInstance((ASN1TaggedObject)seq.getObjectAt(0), false);
            ++n2;
        } else if (seq.size() == 2) {
            this.a = GeneralNames.getInstance(seq.getObjectAt(0));
            ++n2;
        }
        if (!(seq.getObjectAt(n2) instanceof ASN1Sequence)) {
            throw new IllegalArgumentException("Non-IetfAttrSyntax encoding");
        }
        seq = (ASN1Sequence)seq.getObjectAt(n2);
        Enumeration enumeration = seq.getObjects();
        while (enumeration.hasMoreElements()) {
            int n3;
            ASN1Primitive aSN1Primitive = (ASN1Primitive)enumeration.nextElement();
            if (aSN1Primitive instanceof ASN1ObjectIdentifier) {
                n3 = 2;
            } else if (aSN1Primitive instanceof ASN1UTF8String) {
                n3 = 3;
            } else if (aSN1Primitive instanceof DEROctetString) {
                n3 = 1;
            } else {
                throw new IllegalArgumentException("Bad value type encoding IetfAttrSyntax");
            }
            if (this.c < 0) {
                this.c = n3;
            }
            if (n3 != this.c) {
                throw new IllegalArgumentException("Mix of value types in IetfAttrSyntax");
            }
            this.b.addElement(aSN1Primitive);
        }
    }

    public GeneralNames getPolicyAuthority() {
        return this.a;
    }

    public int getValueType() {
        return this.c;
    }

    public Object[] getValues() {
        if (this.getValueType() == 1) {
            Object[] objectArray = new ASN1OctetString[this.b.size()];
            for (int i2 = 0; i2 != objectArray.length; ++i2) {
                objectArray[i2] = (ASN1OctetString)this.b.elementAt(i2);
            }
            return objectArray;
        }
        if (this.getValueType() == 2) {
            Object[] objectArray = new ASN1ObjectIdentifier[this.b.size()];
            for (int i3 = 0; i3 != objectArray.length; ++i3) {
                objectArray[i3] = (ASN1ObjectIdentifier)this.b.elementAt(i3);
            }
            return objectArray;
        }
        Object[] objectArray = new ASN1UTF8String[this.b.size()];
        for (int i4 = 0; i4 != objectArray.length; ++i4) {
            objectArray[i4] = (ASN1UTF8String)this.b.elementAt(i4);
        }
        return objectArray;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        if (this.a != null) {
            aSN1EncodableVector.add(new DERTaggedObject(0, this.a));
        }
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector(this.b.size());
        Enumeration enumeration = this.b.elements();
        while (enumeration.hasMoreElements()) {
            aSN1EncodableVector2.add((ASN1Encodable)enumeration.nextElement());
        }
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        return new DERSequence(aSN1EncodableVector);
    }
}

