/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.DERBitString;
import com.enterprisedt.bouncycastle.asn1.x509.Extension;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;

public class KeyUsage
extends ASN1Object {
    public static final int digitalSignature = 128;
    public static final int nonRepudiation = 64;
    public static final int keyEncipherment = 32;
    public static final int dataEncipherment = 16;
    public static final int keyAgreement = 8;
    public static final int keyCertSign = 4;
    public static final int cRLSign = 2;
    public static final int encipherOnly = 1;
    public static final int decipherOnly = 32768;
    private ASN1BitString a;

    public static KeyUsage getInstance(Object obj) {
        if (obj instanceof KeyUsage) {
            return (KeyUsage)obj;
        }
        if (obj != null) {
            return new KeyUsage(ASN1BitString.getInstance(obj));
        }
        return null;
    }

    public static KeyUsage fromExtensions(Extensions extensions) {
        return KeyUsage.getInstance(Extensions.getExtensionParsedValue(extensions, Extension.keyUsage));
    }

    public KeyUsage(int usage) {
        this.a = new DERBitString(usage);
    }

    private KeyUsage(ASN1BitString bitString) {
        this.a = bitString;
    }

    public boolean hasUsages(int usages) {
        return (this.a.intValue() & usages) == usages;
    }

    public byte[] getBytes() {
        return this.a.getBytes();
    }

    public int getPadBits() {
        return this.a.getPadBits();
    }

    public String toString() {
        byte[] byArray = this.a.getBytes();
        if (byArray.length == 1) {
            return "KeyUsage: 0x" + Integer.toHexString(byArray[0] & 0xFF);
        }
        return "KeyUsage: 0x" + Integer.toHexString((byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }
}

