/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.CertPolicyId;
import java.util.Enumeration;
import java.util.Hashtable;

public class PolicyMappings
extends ASN1Object {
    ASN1Sequence a = null;

    public static PolicyMappings getInstance(Object obj) {
        if (obj instanceof PolicyMappings) {
            return (PolicyMappings)obj;
        }
        if (obj != null) {
            return new PolicyMappings(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private PolicyMappings(ASN1Sequence seq) {
        this.a = seq;
    }

    public PolicyMappings(Hashtable mappings) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(mappings.size());
        Enumeration enumeration = mappings.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)mappings.get(string);
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector(2);
            aSN1EncodableVector2.add(new ASN1ObjectIdentifier(string));
            aSN1EncodableVector2.add(new ASN1ObjectIdentifier(string2));
            aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        }
        this.a = new DERSequence(aSN1EncodableVector);
    }

    public PolicyMappings(CertPolicyId issuerDomainPolicy, CertPolicyId subjectDomainPolicy) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        aSN1EncodableVector.add(issuerDomainPolicy);
        aSN1EncodableVector.add(subjectDomainPolicy);
        this.a = new DERSequence(new DERSequence(aSN1EncodableVector));
    }

    public PolicyMappings(CertPolicyId[] issuerDomainPolicy, CertPolicyId[] subjectDomainPolicy) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(issuerDomainPolicy.length);
        for (int i2 = 0; i2 != issuerDomainPolicy.length; ++i2) {
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector(2);
            aSN1EncodableVector2.add(issuerDomainPolicy[i2]);
            aSN1EncodableVector2.add(subjectDomainPolicy[i2]);
            aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        }
        this.a = new DERSequence(aSN1EncodableVector);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }
}

