/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.Attribute;
import java.util.Enumeration;
import java.util.Vector;

public class SubjectDirectoryAttributes
extends ASN1Object {
    private Vector a = new Vector();

    public static SubjectDirectoryAttributes getInstance(Object obj) {
        if (obj instanceof SubjectDirectoryAttributes) {
            return (SubjectDirectoryAttributes)obj;
        }
        if (obj != null) {
            return new SubjectDirectoryAttributes(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private SubjectDirectoryAttributes(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        while (enumeration.hasMoreElements()) {
            ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(enumeration.nextElement());
            this.a.addElement(Attribute.getInstance(aSN1Sequence));
        }
    }

    public SubjectDirectoryAttributes(Vector attributes) {
        Enumeration enumeration = attributes.elements();
        while (enumeration.hasMoreElements()) {
            this.a.addElement(enumeration.nextElement());
        }
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(this.a.size());
        Enumeration enumeration = this.a.elements();
        while (enumeration.hasMoreElements()) {
            aSN1EncodableVector.add((Attribute)enumeration.nextElement());
        }
        return new DERSequence(aSN1EncodableVector);
    }

    public Vector getAttributes() {
        return this.a;
    }
}

