/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.ASN1UTCTime;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.Time;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class TBSCertList
extends ASN1Object {
    ASN1Integer a;
    AlgorithmIdentifier b;
    X500Name c;
    Time d;
    Time e;
    ASN1Sequence f;
    Extensions g;

    public static TBSCertList getInstance(ASN1TaggedObject obj, boolean explicit) {
        return TBSCertList.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static TBSCertList getInstance(Object obj) {
        if (obj instanceof TBSCertList) {
            return (TBSCertList)obj;
        }
        if (obj != null) {
            return new TBSCertList(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public TBSCertList(ASN1Sequence seq) {
        if (seq.size() < 3 || seq.size() > 7) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        int n2 = 0;
        this.a = seq.getObjectAt(n2) instanceof ASN1Integer ? ASN1Integer.getInstance(seq.getObjectAt(n2++)) : null;
        this.b = AlgorithmIdentifier.getInstance(seq.getObjectAt(n2++));
        this.c = X500Name.getInstance(seq.getObjectAt(n2++));
        this.d = Time.getInstance(seq.getObjectAt(n2++));
        if (n2 < seq.size() && (seq.getObjectAt(n2) instanceof ASN1UTCTime || seq.getObjectAt(n2) instanceof ASN1GeneralizedTime || seq.getObjectAt(n2) instanceof Time)) {
            this.e = Time.getInstance(seq.getObjectAt(n2++));
        }
        if (n2 < seq.size() && !(seq.getObjectAt(n2) instanceof ASN1TaggedObject)) {
            this.f = ASN1Sequence.getInstance(seq.getObjectAt(n2++));
        }
        if (n2 < seq.size() && seq.getObjectAt(n2) instanceof ASN1TaggedObject) {
            this.g = Extensions.getInstance(ASN1Sequence.getInstance((ASN1TaggedObject)seq.getObjectAt(n2), true));
        }
    }

    public int getVersionNumber() {
        if (this.a == null) {
            return 1;
        }
        return this.a.intValueExact() + 1;
    }

    public ASN1Integer getVersion() {
        return this.a;
    }

    public AlgorithmIdentifier getSignature() {
        return this.b;
    }

    public X500Name getIssuer() {
        return this.c;
    }

    public Time getThisUpdate() {
        return this.d;
    }

    public Time getNextUpdate() {
        return this.e;
    }

    public CRLEntry[] getRevokedCertificates() {
        if (this.f == null) {
            return new CRLEntry[0];
        }
        CRLEntry[] cRLEntryArray = new CRLEntry[this.f.size()];
        for (int i2 = 0; i2 < cRLEntryArray.length; ++i2) {
            cRLEntryArray[i2] = CRLEntry.getInstance(this.f.getObjectAt(i2));
        }
        return cRLEntryArray;
    }

    public Enumeration getRevokedCertificateEnumeration() {
        if (this.f == null) {
            return new a();
        }
        return new b(this.f.getObjects());
    }

    public Extensions getExtensions() {
        return this.g;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(7);
        if (this.a != null) {
            aSN1EncodableVector.add(this.a);
        }
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        if (this.e != null) {
            aSN1EncodableVector.add(this.e);
        }
        if (this.f != null) {
            aSN1EncodableVector.add(this.f);
        }
        if (this.g != null) {
            aSN1EncodableVector.add(new DERTaggedObject(0, this.g));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    private static class a
    implements Enumeration {
        private a() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException("Empty Enumeration");
        }
    }

    private static class b
    implements Enumeration {
        private final Enumeration a;

        b(Enumeration enumeration) {
            this.a = enumeration;
        }

        @Override
        public boolean hasMoreElements() {
            return this.a.hasMoreElements();
        }

        public Object nextElement() {
            return CRLEntry.getInstance(this.a.nextElement());
        }
    }

    public static class CRLEntry
    extends ASN1Object {
        ASN1Sequence a;
        Extensions b;

        private CRLEntry(ASN1Sequence seq) {
            if (seq.size() < 2 || seq.size() > 3) {
                throw new IllegalArgumentException("Bad sequence size: " + seq.size());
            }
            this.a = seq;
        }

        public static CRLEntry getInstance(Object o2) {
            if (o2 instanceof CRLEntry) {
                return (CRLEntry)o2;
            }
            if (o2 != null) {
                return new CRLEntry(ASN1Sequence.getInstance(o2));
            }
            return null;
        }

        public ASN1Integer getUserCertificate() {
            return ASN1Integer.getInstance(this.a.getObjectAt(0));
        }

        public Time getRevocationDate() {
            return Time.getInstance(this.a.getObjectAt(1));
        }

        public Extensions getExtensions() {
            if (this.b == null && this.a.size() == 3) {
                this.b = Extensions.getInstance(this.a.getObjectAt(2));
            }
            return this.b;
        }

        @Override
        public ASN1Primitive toASN1Primitive() {
            return this.a;
        }

        public boolean hasExtensions() {
            return this.a.size() == 3;
        }
    }
}

