/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.asn1.x509.Time;
import com.enterprisedt.bouncycastle.util.Properties;

public class TBSCertificate
extends ASN1Object {
    ASN1Sequence a;
    ASN1Integer b;
    ASN1Integer c;
    AlgorithmIdentifier d;
    X500Name e;
    Time f;
    Time g;
    X500Name h;
    SubjectPublicKeyInfo i;
    ASN1BitString j;
    ASN1BitString k;
    Extensions l;

    public static TBSCertificate getInstance(ASN1TaggedObject obj, boolean explicit) {
        return TBSCertificate.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static TBSCertificate getInstance(Object obj) {
        if (obj instanceof TBSCertificate) {
            return (TBSCertificate)obj;
        }
        if (obj != null) {
            return new TBSCertificate(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private TBSCertificate(ASN1Sequence seq) {
        int n2;
        int n3 = 0;
        this.a = seq;
        if (seq.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.b = ASN1Integer.getInstance((ASN1TaggedObject)seq.getObjectAt(0), true);
        } else {
            n3 = -1;
            this.b = new ASN1Integer(0L);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.b.hasValue(0)) {
            bl = true;
        } else if (this.b.hasValue(1)) {
            bl2 = true;
        } else if (!this.b.hasValue(2)) {
            throw new IllegalArgumentException("version number not recognised");
        }
        this.c = ASN1Integer.getInstance(seq.getObjectAt(n3 + 1));
        this.d = AlgorithmIdentifier.getInstance(seq.getObjectAt(n3 + 2));
        this.e = X500Name.getInstance(seq.getObjectAt(n3 + 3));
        ASN1Sequence aSN1Sequence = (ASN1Sequence)seq.getObjectAt(n3 + 4);
        this.f = Time.getInstance(aSN1Sequence.getObjectAt(0));
        this.g = Time.getInstance(aSN1Sequence.getObjectAt(1));
        this.h = X500Name.getInstance(seq.getObjectAt(n3 + 5));
        this.i = SubjectPublicKeyInfo.getInstance(seq.getObjectAt(n3 + 6));
        if (n2 != 0 && bl) {
            throw new IllegalArgumentException("version 1 certificate contains extra data");
        }
        block5: for (n2 = seq.size() - (n3 + 6) - 1; n2 > 0; --n2) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)seq.getObjectAt(n3 + 6 + n2);
            switch (aSN1TaggedObject.getTagNo()) {
                case 1: {
                    this.j = ASN1BitString.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
                case 2: {
                    this.k = ASN1BitString.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
                case 3: {
                    if (bl2) {
                        throw new IllegalArgumentException("version 2 certificate cannot contain extensions");
                    }
                    this.l = Extensions.getInstance(ASN1Sequence.getInstance(aSN1TaggedObject, true));
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Unknown tag encountered in structure: " + aSN1TaggedObject.getTagNo());
                }
            }
        }
    }

    public int getVersionNumber() {
        return this.b.intValueExact() + 1;
    }

    public ASN1Integer getVersion() {
        return this.b;
    }

    public ASN1Integer getSerialNumber() {
        return this.c;
    }

    public AlgorithmIdentifier getSignature() {
        return this.d;
    }

    public X500Name getIssuer() {
        return this.e;
    }

    public Time getStartDate() {
        return this.f;
    }

    public Time getEndDate() {
        return this.g;
    }

    public X500Name getSubject() {
        return this.h;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.i;
    }

    public ASN1BitString getIssuerUniqueId() {
        return this.j;
    }

    public ASN1BitString getSubjectUniqueId() {
        return this.k;
    }

    public Extensions getExtensions() {
        return this.l;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        if (Properties.getPropertyValue("com.enterprisedt.bouncycastle.x509.allow_non-der_tbscert") != null) {
            if (Properties.isOverrideSet("com.enterprisedt.bouncycastle.x509.allow_non-der_tbscert")) {
                return this.a;
            }
        } else {
            return this.a;
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (!this.b.hasValue(0)) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 0, (ASN1Encodable)this.b));
        }
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        aSN1EncodableVector.add(this.e);
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector(2);
        aSN1EncodableVector2.add(this.f);
        aSN1EncodableVector2.add(this.g);
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        if (this.h != null) {
            aSN1EncodableVector.add(this.h);
        } else {
            aSN1EncodableVector.add(new DERSequence());
        }
        aSN1EncodableVector.add(this.i);
        if (this.j != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, (ASN1Encodable)this.j));
        }
        if (this.k != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 2, (ASN1Encodable)this.k));
        }
        if (this.l != null) {
            aSN1EncodableVector.add(new DERTaggedObject(true, 3, (ASN1Encodable)this.l));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

