/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1BitString;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.enterprisedt.bouncycastle.asn1.x509.Time;
import com.enterprisedt.bouncycastle.asn1.x509.X509Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public class TBSCertificateStructure
extends ASN1Object
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    ASN1Sequence a;
    ASN1Integer b;
    ASN1Integer c;
    AlgorithmIdentifier d;
    X500Name e;
    Time f;
    Time g;
    X500Name h;
    SubjectPublicKeyInfo i;
    ASN1BitString j;
    ASN1BitString k;
    X509Extensions l;

    public static TBSCertificateStructure getInstance(ASN1TaggedObject obj, boolean explicit) {
        return TBSCertificateStructure.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static TBSCertificateStructure getInstance(Object obj) {
        if (obj instanceof TBSCertificateStructure) {
            return (TBSCertificateStructure)obj;
        }
        if (obj != null) {
            return new TBSCertificateStructure(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public TBSCertificateStructure(ASN1Sequence seq) {
        int n2 = 0;
        this.a = seq;
        if (seq.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.b = ASN1Integer.getInstance((ASN1TaggedObject)seq.getObjectAt(0), true);
        } else {
            n2 = -1;
            this.b = new ASN1Integer(0L);
        }
        this.c = ASN1Integer.getInstance(seq.getObjectAt(n2 + 1));
        this.d = AlgorithmIdentifier.getInstance(seq.getObjectAt(n2 + 2));
        this.e = X500Name.getInstance(seq.getObjectAt(n2 + 3));
        ASN1Sequence aSN1Sequence = (ASN1Sequence)seq.getObjectAt(n2 + 4);
        this.f = Time.getInstance(aSN1Sequence.getObjectAt(0));
        this.g = Time.getInstance(aSN1Sequence.getObjectAt(1));
        this.h = X500Name.getInstance(seq.getObjectAt(n2 + 5));
        this.i = SubjectPublicKeyInfo.getInstance(seq.getObjectAt(n2 + 6));
        block5: for (int i2 = seq.size() - (n2 + 6) - 1; i2 > 0; --i2) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(seq.getObjectAt(n2 + 6 + i2));
            switch (aSN1TaggedObject.getTagNo()) {
                case 1: {
                    this.j = ASN1BitString.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
                case 2: {
                    this.k = ASN1BitString.getInstance(aSN1TaggedObject, false);
                    continue block5;
                }
                case 3: {
                    this.l = X509Extensions.getInstance(aSN1TaggedObject);
                }
            }
        }
    }

    public int getVersion() {
        return this.b.intValueExact() + 1;
    }

    public ASN1Integer getVersionNumber() {
        return this.b;
    }

    public ASN1Integer getSerialNumber() {
        return this.c;
    }

    public AlgorithmIdentifier getSignature() {
        return this.d;
    }

    public X500Name getIssuer() {
        return this.e;
    }

    public Time getStartDate() {
        return this.f;
    }

    public Time getEndDate() {
        return this.g;
    }

    public X500Name getSubject() {
        return this.h;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.i;
    }

    public ASN1BitString getIssuerUniqueId() {
        return this.j;
    }

    public ASN1BitString getSubjectUniqueId() {
        return this.k;
    }

    public X509Extensions getExtensions() {
        return this.l;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }
}

