/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x509.GeneralNames;
import com.enterprisedt.bouncycastle.asn1.x509.IssuerSerial;
import com.enterprisedt.bouncycastle.asn1.x509.ObjectDigestInfo;

public class V2Form
extends ASN1Object {
    GeneralNames a;
    IssuerSerial b;
    ObjectDigestInfo c;

    public static V2Form getInstance(ASN1TaggedObject obj, boolean explicit) {
        return V2Form.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public static V2Form getInstance(Object obj) {
        if (obj instanceof V2Form) {
            return (V2Form)obj;
        }
        if (obj != null) {
            return new V2Form(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public V2Form(GeneralNames issuerName) {
        this(issuerName, null, null);
    }

    public V2Form(GeneralNames issuerName, IssuerSerial baseCertificateID) {
        this(issuerName, baseCertificateID, null);
    }

    public V2Form(GeneralNames issuerName, ObjectDigestInfo objectDigestInfo) {
        this(issuerName, null, objectDigestInfo);
    }

    public V2Form(GeneralNames issuerName, IssuerSerial baseCertificateID, ObjectDigestInfo objectDigestInfo) {
        this.a = issuerName;
        this.b = baseCertificateID;
        this.c = objectDigestInfo;
    }

    private V2Form(ASN1Sequence seq) {
        if (seq.size() > 3) {
            throw new IllegalArgumentException("Bad sequence size: " + seq.size());
        }
        int n2 = 0;
        if (!(seq.getObjectAt(0) instanceof ASN1TaggedObject)) {
            ++n2;
            this.a = GeneralNames.getInstance(seq.getObjectAt(0));
        }
        for (int i2 = n2; i2 != seq.size(); ++i2) {
            ASN1TaggedObject aSN1TaggedObject = ASN1TaggedObject.getInstance(seq.getObjectAt(i2));
            if (aSN1TaggedObject.getTagNo() == 0) {
                this.b = IssuerSerial.getInstance(aSN1TaggedObject, false);
                continue;
            }
            if (aSN1TaggedObject.getTagNo() == 1) {
                this.c = ObjectDigestInfo.getInstance(aSN1TaggedObject, false);
                continue;
            }
            throw new IllegalArgumentException("Bad tag number: " + aSN1TaggedObject.getTagNo());
        }
    }

    public GeneralNames getIssuerName() {
        return this.a;
    }

    public IssuerSerial getBaseCertificateID() {
        return this.b;
    }

    public ObjectDigestInfo getObjectDigestInfo() {
        return this.c;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        if (this.a != null) {
            aSN1EncodableVector.add(this.a);
        }
        if (this.b != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 0, (ASN1Encodable)this.b));
        }
        if (this.c != null) {
            aSN1EncodableVector.add(new DERTaggedObject(false, 1, (ASN1Encodable)this.c));
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

