/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1GeneralizedTime;
import com.enterprisedt.bouncycastle.asn1.ASN1Integer;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.ASN1UTCTime;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.DERTaggedObject;
import com.enterprisedt.bouncycastle.asn1.x500.X500Name;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.CRLReason;
import com.enterprisedt.bouncycastle.asn1.x509.Extension;
import com.enterprisedt.bouncycastle.asn1.x509.Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.TBSCertList;
import com.enterprisedt.bouncycastle.asn1.x509.Time;
import com.enterprisedt.bouncycastle.asn1.x509.X509Extensions;
import com.enterprisedt.bouncycastle.asn1.x509.X509Name;
import java.io.IOException;

public class V2TBSCertListGenerator {
    private ASN1Integer a = new ASN1Integer(1L);
    private AlgorithmIdentifier b;
    private X500Name c;
    private Time d;
    private Time e = null;
    private Extensions f = null;
    private ASN1EncodableVector g = new ASN1EncodableVector();
    private static final ASN1Sequence[] h = new ASN1Sequence[11];

    public void setSignature(AlgorithmIdentifier signature) {
        this.b = signature;
    }

    public void setIssuer(X509Name issuer) {
        this.c = X500Name.getInstance(issuer.toASN1Primitive());
    }

    public void setIssuer(X500Name issuer) {
        this.c = issuer;
    }

    public void setThisUpdate(ASN1UTCTime thisUpdate) {
        this.d = new Time(thisUpdate);
    }

    public void setNextUpdate(ASN1UTCTime nextUpdate) {
        this.e = new Time(nextUpdate);
    }

    public void setThisUpdate(Time thisUpdate) {
        this.d = thisUpdate;
    }

    public void setNextUpdate(Time nextUpdate) {
        this.e = nextUpdate;
    }

    public void addCRLEntry(ASN1Sequence crlEntry) {
        this.g.add(crlEntry);
    }

    public void addCRLEntry(ASN1Integer userCertificate, ASN1UTCTime revocationDate, int reason) {
        this.addCRLEntry(userCertificate, new Time(revocationDate), reason);
    }

    public void addCRLEntry(ASN1Integer userCertificate, Time revocationDate, int reason) {
        this.addCRLEntry(userCertificate, revocationDate, reason, null);
    }

    public void addCRLEntry(ASN1Integer userCertificate, Time revocationDate, int reason, ASN1GeneralizedTime invalidityDate) {
        if (reason != 0) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
            if (reason < h.length) {
                if (reason < 0) {
                    throw new IllegalArgumentException("invalid reason value: " + reason);
                }
                aSN1EncodableVector.add(h[reason]);
            } else {
                aSN1EncodableVector.add(V2TBSCertListGenerator.a(reason));
            }
            if (invalidityDate != null) {
                aSN1EncodableVector.add(V2TBSCertListGenerator.a(invalidityDate));
            }
            this.a(userCertificate, revocationDate, new DERSequence(aSN1EncodableVector));
        } else if (invalidityDate != null) {
            this.a(userCertificate, revocationDate, new DERSequence(V2TBSCertListGenerator.a(invalidityDate)));
        } else {
            this.addCRLEntry(userCertificate, revocationDate, null);
        }
    }

    private void a(ASN1Integer aSN1Integer, Time time, ASN1Sequence aSN1Sequence) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(aSN1Integer);
        aSN1EncodableVector.add(time);
        if (aSN1Sequence != null) {
            aSN1EncodableVector.add(aSN1Sequence);
        }
        this.addCRLEntry(new DERSequence(aSN1EncodableVector));
    }

    public void addCRLEntry(ASN1Integer userCertificate, Time revocationDate, Extensions extensions) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(3);
        aSN1EncodableVector.add(userCertificate);
        aSN1EncodableVector.add(revocationDate);
        if (extensions != null) {
            aSN1EncodableVector.add(extensions);
        }
        this.addCRLEntry(new DERSequence(aSN1EncodableVector));
    }

    public void setExtensions(X509Extensions extensions) {
        this.setExtensions(Extensions.getInstance(extensions));
    }

    public void setExtensions(Extensions extensions) {
        this.f = extensions;
    }

    public TBSCertList generateTBSCertList() {
        if (this.b == null || this.c == null || this.d == null) {
            throw new IllegalStateException("not all mandatory fields set in V2 TBSCertList generator");
        }
        return new TBSCertList(this.a());
    }

    public ASN1Sequence generatePreTBSCertList() {
        if (this.b != null) {
            throw new IllegalStateException("signature should not be set in PreTBSCertList generator");
        }
        if (this.c == null || this.d == null) {
            throw new IllegalStateException("not all mandatory fields set in V2 PreTBSCertList generator");
        }
        return this.a();
    }

    private ASN1Sequence a() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(7);
        aSN1EncodableVector.add(this.a);
        if (this.b != null) {
            aSN1EncodableVector.add(this.b);
        }
        aSN1EncodableVector.add(this.c);
        aSN1EncodableVector.add(this.d);
        if (this.e != null) {
            aSN1EncodableVector.add(this.e);
        }
        if (this.g.size() != 0) {
            aSN1EncodableVector.add(new DERSequence(this.g));
        }
        if (this.f != null) {
            aSN1EncodableVector.add(new DERTaggedObject(0, this.f));
        }
        return new DERSequence(aSN1EncodableVector);
    }

    private static ASN1Sequence a(int n2) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        CRLReason cRLReason = CRLReason.lookup(n2);
        try {
            aSN1EncodableVector.add(Extension.reasonCode);
            aSN1EncodableVector.add(new DEROctetString(cRLReason.getEncoded()));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error encoding reason: " + iOException);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    private static ASN1Sequence a(ASN1GeneralizedTime aSN1GeneralizedTime) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(2);
        try {
            aSN1EncodableVector.add(Extension.invalidityDate);
            aSN1EncodableVector.add(new DEROctetString(aSN1GeneralizedTime.getEncoded()));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error encoding reason: " + iOException);
        }
        return new DERSequence(aSN1EncodableVector);
    }

    static {
        V2TBSCertListGenerator.h[0] = V2TBSCertListGenerator.a(0);
        V2TBSCertListGenerator.h[1] = V2TBSCertListGenerator.a(1);
        V2TBSCertListGenerator.h[2] = V2TBSCertListGenerator.a(2);
        V2TBSCertListGenerator.h[3] = V2TBSCertListGenerator.a(3);
        V2TBSCertListGenerator.h[4] = V2TBSCertListGenerator.a(4);
        V2TBSCertListGenerator.h[5] = V2TBSCertListGenerator.a(5);
        V2TBSCertListGenerator.h[6] = V2TBSCertListGenerator.a(6);
        V2TBSCertListGenerator.h[7] = V2TBSCertListGenerator.a(7);
        V2TBSCertListGenerator.h[8] = V2TBSCertListGenerator.a(8);
        V2TBSCertListGenerator.h[9] = V2TBSCertListGenerator.a(9);
        V2TBSCertListGenerator.h[10] = V2TBSCertListGenerator.a(10);
    }
}

