/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509;

import com.enterprisedt.bouncycastle.asn1.ASN1Encodable;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.DEROctetString;
import com.enterprisedt.bouncycastle.asn1.x509.X509Extension;
import com.enterprisedt.bouncycastle.asn1.x509.X509Extensions;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class X509ExtensionsGenerator {
    private Hashtable a = new Hashtable();
    private Vector b = new Vector();

    public void reset() {
        this.a = new Hashtable();
        this.b = new Vector();
    }

    public void addExtension(ASN1ObjectIdentifier oid, boolean critical, ASN1Encodable value) {
        try {
            this.addExtension(oid, critical, value.toASN1Primitive().getEncoded("DER"));
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("error encoding value: " + iOException);
        }
    }

    public void addExtension(ASN1ObjectIdentifier oid, boolean critical, byte[] value) {
        if (this.a.containsKey(oid)) {
            throw new IllegalArgumentException("extension " + oid + " already added");
        }
        this.b.addElement(oid);
        this.a.put(oid, new X509Extension(critical, (ASN1OctetString)new DEROctetString(value)));
    }

    public boolean isEmpty() {
        return this.b.isEmpty();
    }

    public X509Extensions generate() {
        return new X509Extensions(this.b, this.a);
    }
}

