/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x509.qualified;

import com.enterprisedt.bouncycastle.asn1.ASN1EncodableVector;
import com.enterprisedt.bouncycastle.asn1.ASN1IA5String;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1OctetString;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1Sequence;
import com.enterprisedt.bouncycastle.asn1.DERIA5String;
import com.enterprisedt.bouncycastle.asn1.DERSequence;
import com.enterprisedt.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.enterprisedt.bouncycastle.asn1.x509.qualified.TypeOfBiometricData;
import java.util.Enumeration;

public class BiometricData
extends ASN1Object {
    private TypeOfBiometricData a;
    private AlgorithmIdentifier b;
    private ASN1OctetString c;
    private ASN1IA5String d;

    public static BiometricData getInstance(Object obj) {
        if (obj instanceof BiometricData) {
            return (BiometricData)obj;
        }
        if (obj != null) {
            return new BiometricData(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    private BiometricData(ASN1Sequence seq) {
        Enumeration enumeration = seq.getObjects();
        this.a = TypeOfBiometricData.getInstance(enumeration.nextElement());
        this.b = AlgorithmIdentifier.getInstance(enumeration.nextElement());
        this.c = ASN1OctetString.getInstance(enumeration.nextElement());
        if (enumeration.hasMoreElements()) {
            this.d = ASN1IA5String.getInstance(enumeration.nextElement());
        }
    }

    public BiometricData(TypeOfBiometricData typeOfBiometricData, AlgorithmIdentifier hashAlgorithm, ASN1OctetString biometricDataHash, ASN1IA5String sourceDataUri) {
        this.a = typeOfBiometricData;
        this.b = hashAlgorithm;
        this.c = biometricDataHash;
        this.d = sourceDataUri;
    }

    public BiometricData(TypeOfBiometricData typeOfBiometricData, AlgorithmIdentifier hashAlgorithm, ASN1OctetString biometricDataHash) {
        this.a = typeOfBiometricData;
        this.b = hashAlgorithm;
        this.c = biometricDataHash;
        this.d = null;
    }

    public TypeOfBiometricData getTypeOfBiometricData() {
        return this.a;
    }

    public AlgorithmIdentifier getHashAlgorithm() {
        return this.b;
    }

    public ASN1OctetString getBiometricDataHash() {
        return this.c;
    }

    public DERIA5String getSourceDataUri() {
        return null == this.d || this.d instanceof DERIA5String ? (DERIA5String)this.d : new DERIA5String(this.d.getString(), false);
    }

    public ASN1IA5String getSourceDataUriIA5() {
        return this.d;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector(4);
        aSN1EncodableVector.add(this.a);
        aSN1EncodableVector.add(this.b);
        aSN1EncodableVector.add(this.c);
        if (this.d != null) {
            aSN1EncodableVector.add(this.d);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

