/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.asn1.x9;

import com.enterprisedt.bouncycastle.asn1.ASN1Choice;
import com.enterprisedt.bouncycastle.asn1.ASN1Null;
import com.enterprisedt.bouncycastle.asn1.ASN1Object;
import com.enterprisedt.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.enterprisedt.bouncycastle.asn1.ASN1Primitive;
import com.enterprisedt.bouncycastle.asn1.ASN1TaggedObject;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;

public class X962Parameters
extends ASN1Object
implements ASN1Choice {
    private ASN1Primitive a = null;

    public static X962Parameters getInstance(Object obj) {
        if (obj == null || obj instanceof X962Parameters) {
            return (X962Parameters)obj;
        }
        if (obj instanceof ASN1Primitive) {
            return new X962Parameters((ASN1Primitive)obj);
        }
        if (obj instanceof byte[]) {
            try {
                return new X962Parameters(ASN1Primitive.fromByteArray((byte[])obj));
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("unable to parse encoded data: " + exception.getMessage());
            }
        }
        throw new IllegalArgumentException("unknown object in getInstance()");
    }

    public static X962Parameters getInstance(ASN1TaggedObject obj, boolean explicit) {
        if (!explicit) {
            throw new IllegalArgumentException("choice item must be explicitly tagged");
        }
        return X962Parameters.getInstance(obj.getExplicitBaseObject());
    }

    public X962Parameters(X9ECParameters ecParameters) {
        this.a = ecParameters.toASN1Primitive();
    }

    public X962Parameters(ASN1ObjectIdentifier namedCurve) {
        this.a = namedCurve;
    }

    public X962Parameters(ASN1Null obj) {
        this.a = obj;
    }

    private X962Parameters(ASN1Primitive obj) {
        this.a = obj;
    }

    public boolean isNamedCurve() {
        return this.a instanceof ASN1ObjectIdentifier;
    }

    public boolean isImplicitlyCA() {
        return this.a instanceof ASN1Null;
    }

    public ASN1Primitive getParameters() {
        return this.a;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return this.a;
    }
}

